/*
 * Decompiled with CFR 0.152.
 */
package com.zhimi.usbserial.util;

import com.alibaba.fastjson.JSONArray;

public class ByteUtil {
    public static byte[] hexToByte(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    public static String byteArrayToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ByteUtil.byteArrayToString(bytes, 0, bytes.length);
    }

    public static String byteArrayToString(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < bytes.length && i < offset + len; ++i) {
            int tmp;
            for (tmp = bytes[i]; tmp < 0; tmp += 256) {
            }
            if (tmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(tmp, 16));
        }
        return sb.toString().toUpperCase();
    }

    public static String byteArrayToformatString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ByteUtil.byteArrayToformatString(bytes, 0, bytes.length);
    }

    public static String byteArrayToformatString(byte[] bytes, int offset, int len) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < bytes.length && i < offset + len; ++i) {
            int tmp;
            for (tmp = bytes[i]; tmp < 0; tmp += 256) {
            }
            if (i > offset) {
                sb.append(" ");
            }
            if (tmp < 16) {
                sb.append("0");
            }
            sb.append(Integer.toString(tmp, 16));
        }
        return sb.toString().toUpperCase();
    }

    public static int getValue(byte b1, byte b2) {
        int data1 = ByteUtil.byteToInt(b1);
        int data2 = ByteUtil.byteToInt(b2);
        return (data1 << 8) + data2;
    }

    public static int getValue(byte b1, byte b2, byte b3) {
        int data1 = ByteUtil.byteToInt(b1);
        int data2 = ByteUtil.byteToInt(b2);
        int data3 = ByteUtil.byteToInt(b3);
        return (data1 << 16) + (data2 << 8) + data3;
    }

    public static long getValue(byte b1, byte b2, byte b3, byte b4) {
        long data1 = ByteUtil.byteToInt(b1);
        long data2 = ByteUtil.byteToInt(b2);
        long data3 = ByteUtil.byteToInt(b2);
        long data4 = ByteUtil.byteToInt(b3);
        return (data1 << 24) + (data2 << 16) + (data3 << 8) + data4;
    }

    public static int byteToInt(byte b) {
        return b < 0 ? b + 256 : b;
    }

    public static byte[] jsonArrayToBytes(JSONArray array) {
        return ByteUtil.jsonArrayToBytes(array, null);
    }

    public static byte[] jsonArrayToBytes(JSONArray array, byte[] dv) {
        if (array != null) {
            byte[] data = new byte[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                data[i] = array.getByteValue(i);
            }
            return data;
        }
        return dv;
    }

    public static byte getCheckSum8Value(byte[] data) {
        if (data == null) {
            return 0;
        }
        return ByteUtil.getCheckSum8Value(data, 0, data.length);
    }

    public static byte getCheckSum8Value(byte[] data, int offset, int length) {
        byte checkSum = 0;
        if (data != null && data.length > 0) {
            for (int i = offset; i < data.length && i < offset + length; ++i) {
                checkSum = (byte)(checkSum + data[i]);
            }
            checkSum = (byte)(~checkSum + 1);
        }
        return checkSum;
    }

    public static byte[] generateCheckSumData(byte[] data) {
        if (data != null && data.length > 0) {
            byte[] buffer = new byte[data.length + 3];
            int checkSum = 0;
            for (int i = 0; i < data.length; ++i) {
                buffer[i] = data[i];
                int b = data[i];
                checkSum += b < 0 ? b + 256 : b;
            }
            checkSum = ~checkSum + 1;
            byte checkSumHigh = (byte)(checkSum >> 8);
            byte checkSumLow = (byte)(checkSum & 0xFF);
            buffer[data.length] = checkSumHigh;
            buffer[data.length + 1] = checkSumLow;
            buffer[data.length + 2] = -86;
            return buffer;
        }
        return null;
    }

    public static byte[] generateCRC16Data(byte[] data) {
        if (data != null && data.length > 0) {
            byte[] buffer = new byte[data.length + 2];
            int crc = 65535;
            for (int i = 0; i < data.length; ++i) {
                byte b;
                buffer[i] = b = data[i];
                crc = (crc & 0xFF00) + (b ^ crc & 0xFF);
                for (int j = 0; j < 8; ++j) {
                    int m = crc & 1;
                    crc >>= 1;
                    if (m != 1) continue;
                    crc ^= 0xA001;
                }
            }
            byte crcHigh = (byte)(crc >> 8);
            byte crcLow = (byte)(crc & 0xFF);
            buffer[data.length] = crcHigh;
            buffer[data.length + 1] = crcLow;
            return buffer;
        }
        return null;
    }

    public static byte[] generateCRC8Data(byte[] data) {
        if (data != null && data.length > 0) {
            byte[] buffer = new byte[data.length + 1];
            byte crc = 0;
            for (int j = 0; j < data.length; ++j) {
                buffer[j] = data[j];
                crc = (byte)(crc ^ data[j]);
                for (int i = 0; i < 8; ++i) {
                    if ((crc & 1) != 0) {
                        crc = (byte)((crc & 0xFF) >>> 1);
                        crc = (byte)(crc ^ 0x8C);
                        continue;
                    }
                    crc = (byte)((crc & 0xFF) >>> 1);
                }
            }
            buffer[data.length] = crc;
            return buffer;
        }
        return data;
    }
}

