/*
 * Decompiled with CFR 0.152.
 */
package com.zhimi.usbserial;

import android.app.Activity;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.zhimi.usbserial.UsbSerialManager;
import com.zhimi.usbserial.util.ByteUtil;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;

public class UsbSerialModule
extends UniModule {
    @UniJSMethod
    public void setDataCallback(UniJSCallback jsCallback) {
        UsbSerialManager.getInstance().setDataCallback(jsCallback);
    }

    @UniJSMethod
    public void getUsbDevices(UniJSCallback jsCallback) {
        JSONArray array = UsbSerialManager.getInstance().getDevices(this.mUniSDKInstance.getContext());
        if (jsCallback != null) {
            jsCallback.invoke((Object)array);
        }
    }

    @UniJSMethod(uiThread=false)
    public boolean hasUsbPermission(int vendorId) {
        return UsbSerialManager.getInstance().hasUsbPermission(this.mUniSDKInstance.getContext(), vendorId);
    }

    @UniJSMethod
    public void grantUsbPermission(int vendorId, UniJSCallback jsCallback) {
        UsbSerialManager.getInstance().grantUsbPermission(this.mUniSDKInstance.getContext(), vendorId, jsCallback);
    }

    @UniJSMethod
    public void open(final int vendorId, final int port, final UniJSCallback jsCallback) {
        if (this.mUniSDKInstance.getContext() instanceof Activity) {
            final Activity activity = (Activity)this.mUniSDKInstance.getContext();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final Boolean ret = UsbSerialManager.getInstance().open(UsbSerialModule.this.mUniSDKInstance.getContext(), vendorId, port);
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (jsCallback != null) {
                                jsCallback.invoke((Object)ret);
                            }
                        }
                    });
                }
            }).start();
        }
    }

    @UniJSMethod
    public void close() {
        UsbSerialManager.getInstance().close();
    }

    @UniJSMethod
    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) {
        UsbSerialManager.getInstance().setParameters(baudRate, dataBits, stopBits, parity);
    }

    @UniJSMethod
    public void setBreak(boolean enable) {
        UsbSerialManager.getInstance().setBreak(enable);
    }

    @UniJSMethod(uiThread=false)
    public boolean getDTR() {
        return UsbSerialManager.getInstance().getDTR();
    }

    @UniJSMethod
    public void setDTR(boolean enable) {
        UsbSerialManager.getInstance().setDTR(enable);
    }

    @UniJSMethod(uiThread=false)
    public boolean getRTS() {
        return UsbSerialManager.getInstance().getRTS();
    }

    @UniJSMethod
    public void setRTS(boolean enable) {
        UsbSerialManager.getInstance().setRTS(enable);
    }

    @UniJSMethod(uiThread=false)
    public boolean getCTS() {
        return UsbSerialManager.getInstance().getCTS();
    }

    @UniJSMethod(uiThread=false)
    public boolean getDSR() {
        return UsbSerialManager.getInstance().getDSR();
    }

    @UniJSMethod
    public void writeData(byte[] data, int timeout) {
        UsbSerialManager.getInstance().writeData(data, timeout);
    }

    @UniJSMethod
    public void writeString(String data, int timeout) {
        if (!TextUtils.isEmpty((CharSequence)data)) {
            UsbSerialManager.getInstance().writeData(data.getBytes(), timeout);
        }
    }

    @UniJSMethod
    public void writeHex(String hex, int timeout) {
        if (!TextUtils.isEmpty((CharSequence)hex)) {
            UsbSerialManager.getInstance().writeData(ByteUtil.hexToByte(hex), timeout);
        }
    }

    @UniJSMethod
    public void setReceiveTime(int type, int time) {
        UsbSerialManager.getInstance().setOutTime(time);
        UsbSerialManager.getInstance().setType(type);
    }
}

