/*
 * Decompiled with CFR 0.152.
 */
package com.zhimi.usbserial;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialProber;
import com.hoho.android.usbserial.util.SerialInputOutputManager;
import com.zhimi.usbserial.util.ByteUtil;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class UsbSerialManager
implements SerialInputOutputManager.Listener {
    private static final String ACTION_USB_PERMISSION = "com.zhimi.usbserial.USB_PERMISSION";
    private UsbSerialPort mUsbSerialPort = null;
    private SerialInputOutputManager mUsbIoManager = null;
    private UniJSCallback mDataCallback = null;
    private UniJSCallback mGrantCallback = null;
    private static UsbSerialManager instance = null;
    private int outTimee = 0;
    private int outTimeBi = 0;
    private String intervalString = "";
    private String intervalHex = "";
    private String currentString;
    Timer timer;
    private boolean timerIsStart;
    private int mtype;
    private BroadcastReceiver mUsbBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                UsbSerialManager.this.onKeepAliveCallback("onUsbDeviceAttached", UsbSerialManager.this.convertUsbDevice(usbDevice));
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
                UsbSerialManager.this.onKeepAliveCallback("onUsbDeviceDetached", UsbSerialManager.this.convertUsbDevice(usbDevice));
            }
        }
    };
    private BroadcastReceiver mUsbPermissionActionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (UsbSerialManager.ACTION_USB_PERMISSION.equals(action)) {
                Boolean ret = intent.getBooleanExtra("permission", false);
                if (UsbSerialManager.this.mGrantCallback != null) {
                    UsbSerialManager.this.mGrantCallback.invoke((Object)ret);
                    UsbSerialManager.this.mGrantCallback = null;
                }
            }
        }
    };
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (UsbSerialManager.this.mDataCallback != null) {
                UsbSerialManager.this.mDataCallback.invokeAndKeepAlive(msg.obj);
            }
            return false;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UsbSerialManager getInstance() {
        if (instance != null) return instance;
        Class<UsbSerialManager> clazz = UsbSerialManager.class;
        synchronized (UsbSerialManager.class) {
            if (instance != null) return instance;
            instance = new UsbSerialManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UsbSerialManager() {
    }

    public void init(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        filter.setPriority(Integer.MAX_VALUE);
        context.registerReceiver(this.mUsbBroadcastReceiver, filter);
        IntentFilter permissionFilter = new IntentFilter(ACTION_USB_PERMISSION);
        context.registerReceiver(this.mUsbPermissionActionReceiver, permissionFilter);
    }

    public void setDataCallback(UniJSCallback jsCallback) {
        this.mDataCallback = jsCallback;
    }

    public JSONArray getDevices(Context context) {
        UsbManager manager = (UsbManager)context.getSystemService("usb");
        List availableDrivers = UsbSerialProber.getDefaultProber().findAllDrivers(manager);
        JSONArray array = new JSONArray();
        if (availableDrivers != null && availableDrivers.size() > 0) {
            for (int i = 0; i < availableDrivers.size(); ++i) {
                UsbSerialDriver driver = (UsbSerialDriver)availableDrivers.get(i);
                JSONObject obj = new JSONObject();
                obj.put("device", (Object)this.convertUsbDevice(driver.getDevice()));
                obj.put("ports", this.convertUsbSerialPorts(driver.getPorts()));
                array.add((Object)obj);
            }
        }
        return array;
    }

    public boolean hasUsbPermission(Context context, int vendorId) {
        UsbManager manager = (UsbManager)context.getSystemService("usb");
        UsbSerialDriver driver = this.getUsbSerialDriver(manager, vendorId);
        if (driver != null && driver.getDevice() != null) {
            return manager.hasPermission(driver.getDevice());
        }
        return false;
    }

    public void grantUsbPermission(Context context, int vendorId, UniJSCallback jsCallback) {
        UsbManager manager = (UsbManager)context.getSystemService("usb");
        UsbSerialDriver driver = this.getUsbSerialDriver(manager, vendorId);
        PendingIntent mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        if (driver != null && driver.getDevice() != null) {
            if (!manager.hasPermission(driver.getDevice())) {
                this.mGrantCallback = jsCallback;
                manager.requestPermission(driver.getDevice(), mPermissionIntent);
            } else if (jsCallback != null) {
                Boolean ret = true;
                jsCallback.invoke((Object)ret);
            }
        }
    }

    public boolean open(Context context, int vendorId, int port) {
        if (this.mUsbSerialPort != null) {
            return true;
        }
        UsbManager manager = (UsbManager)context.getSystemService("usb");
        UsbSerialDriver driver = this.getUsbSerialDriver(manager, vendorId);
        if (driver != null) {
            UsbDeviceConnection connection = manager.openDevice(driver.getDevice());
            if (connection == null) {
                return false;
            }
            UsbSerialPort usbSerialPort = this.getUsbSerialPort(driver.getPorts(), port);
            try {
                usbSerialPort.open(connection);
                this.mUsbIoManager = new SerialInputOutputManager(usbSerialPort, (SerialInputOutputManager.Listener)this);
                this.mUsbIoManager.start();
                this.mUsbSerialPort = usbSerialPort;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void close() {
        if (this.mUsbIoManager != null) {
            this.mUsbIoManager.stop();
            this.mUsbIoManager = null;
        }
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mUsbSerialPort = null;
        }
        this.timerIsStart = false;
    }

    public void setParameters(int baudRate, int dataBits, int stopBits, int parity) {
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.setParameters(baudRate, dataBits, stopBits, parity);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setBreak(boolean enable) {
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.setBreak(enable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDTR(boolean enable) {
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.setDTR(enable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getDTR() {
        if (this.mUsbSerialPort != null) {
            try {
                return this.mUsbSerialPort.getDTR();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void setRTS(boolean enable) {
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.setRTS(enable);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getRTS() {
        if (this.mUsbSerialPort != null) {
            try {
                return this.mUsbSerialPort.getRTS();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean getCTS() {
        if (this.mUsbSerialPort != null) {
            try {
                return this.mUsbSerialPort.getCTS();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean getDSR() {
        if (this.mUsbSerialPort != null) {
            try {
                return this.mUsbSerialPort.getDSR();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void writeData(byte[] data, int timeout) {
        if (this.mUsbSerialPort != null) {
            try {
                this.mUsbSerialPort.write(data, timeout);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private JSONObject convertUsbDevice(UsbDevice usbDevice) {
        JSONObject obj = new JSONObject();
        if (usbDevice != null) {
            obj.put("deviceId", (Object)usbDevice.getDeviceId());
            obj.put("deviceName", (Object)usbDevice.getDeviceName());
            obj.put("vendorId", (Object)usbDevice.getVendorId());
            obj.put("deviceClass", (Object)usbDevice.getDeviceClass());
            obj.put("deviceProtocol", (Object)usbDevice.getDeviceProtocol());
            obj.put("deviceSubclass", (Object)usbDevice.getDeviceSubclass());
            obj.put("productId", (Object)usbDevice.getProductId());
            obj.put("productName", (Object)usbDevice.getProductName());
            obj.put("manufacturerName", (Object)usbDevice.getManufacturerName());
            obj.put("interfaceCount", (Object)usbDevice.getInterfaceCount());
            obj.put("configurationCount", (Object)usbDevice.getConfigurationCount());
        }
        return obj;
    }

    private List<Integer> convertUsbSerialPorts(List<UsbSerialPort> ports) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (ports != null && ports.size() > 0) {
            for (UsbSerialPort model : ports) {
                array.add(model.getPortNumber());
            }
        }
        return array;
    }

    private UsbSerialDriver getUsbSerialDriver(UsbManager manager, int vendorId) {
        List availableDrivers = UsbSerialProber.getDefaultProber().findAllDrivers(manager);
        if (!availableDrivers.isEmpty()) {
            for (int i = 0; i < availableDrivers.size(); ++i) {
                UsbSerialDriver driver = (UsbSerialDriver)availableDrivers.get(i);
                UsbDevice usbDevice = driver.getDevice();
                if (usbDevice == null || vendorId != usbDevice.getVendorId()) continue;
                return driver;
            }
        }
        return null;
    }

    private UsbSerialPort getUsbSerialPort(List<UsbSerialPort> ports, int port) {
        if (ports != null && ports.size() > 0) {
            for (UsbSerialPort model : ports) {
                if (model.getPortNumber() != port) continue;
                return model;
            }
        }
        return null;
    }

    private void onKeepAliveCallback(String type, Object data) {
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)type);
        obj.put("data", data);
        Message msg = Message.obtain();
        msg.obj = obj;
        this.mHandler.sendMessage(msg);
    }

    public void onNewData(byte[] data) {
        String string = new String(data);
        String hex = ByteUtil.byteArrayToString(data);
        this.intervalHex = this.intervalHex + hex;
        this.intervalString = this.intervalString + string;
        this.currentString = string;
        if (this.outTimee > 0 && this.mtype > 0) {
            if (!this.timerIsStart) {
                this.onKeepAliveCallback("startUpdateValue", null);
                this.timerIsStart = true;
                if (this.mtype == 1) {
                    this.timer = new Timer();
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            if (UsbSerialManager.this.currentString.length() == 0) {
                                UsbSerialManager.this.timer.cancel();
                                UsbSerialManager.this.timerIsStart = false;
                                UsbSerialManager.this.intervalHex = "";
                                UsbSerialManager.this.intervalString = "";
                                UsbSerialManager.this.currentString = "";
                            } else {
                                JSONObject object = new JSONObject();
                                object.put("hex", (Object)UsbSerialManager.this.intervalHex);
                                object.put("string", (Object)UsbSerialManager.this.intervalString);
                                UsbSerialManager.this.onKeepAliveCallback("onNewData", object);
                                UsbSerialManager.this.intervalHex = "";
                                UsbSerialManager.this.intervalString = "";
                                UsbSerialManager.this.currentString = "";
                            }
                        }
                    };
                    this.timer.schedule(task, this.outTimee, (long)this.outTimee);
                } else if (this.mtype == 2) {
                    this.timer = new Timer();
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            UsbSerialManager.this.outTimeBi++;
                            if (UsbSerialManager.this.outTimee == UsbSerialManager.this.outTimeBi) {
                                if (UsbSerialManager.this.intervalString.length() > 0) {
                                    JSONObject object = new JSONObject();
                                    object.put("hex", (Object)UsbSerialManager.this.intervalHex);
                                    object.put("string", (Object)UsbSerialManager.this.intervalString);
                                    UsbSerialManager.this.onKeepAliveCallback("onNewData", object);
                                }
                                UsbSerialManager.this.timer.cancel();
                                UsbSerialManager.this.outTimeBi = 0;
                                UsbSerialManager.this.timerIsStart = false;
                                UsbSerialManager.this.intervalHex = "";
                                UsbSerialManager.this.intervalString = "";
                            } else if (UsbSerialManager.this.currentString.length() > 0) {
                                UsbSerialManager.this.outTimeBi = 0;
                                UsbSerialManager.this.currentString = "";
                            }
                        }
                    };
                    this.timer.schedule(task, 0L, 1L);
                }
            }
        } else {
            JSONObject obj = new JSONObject();
            obj.put("data", (Object)data);
            obj.put("string", (Object)new String(data));
            obj.put("hex", (Object)ByteUtil.byteArrayToString(data));
            this.onKeepAliveCallback("onNewData", obj);
        }
    }

    public void onRunError(Exception e) {
        this.onKeepAliveCallback("onRunError", e.getMessage());
    }

    public void setOutTime(int time) {
        this.outTimee = time;
    }

    public void setType(int type) {
        this.mtype = type;
    }
}

