/*
 * Decompiled with CFR 0.152.
 */
package com.example.zhimible;

import android.content.Context;
import com.alibaba.fastjson.JSONObject;
import com.example.zhimible.CallbackUtil;
import com.example.zhimible.ECBLE;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class zhimiBLEManager {
    protected JSCallback mDataCallback = null;
    private static zhimiBLEManager instance = null;
    private Context mContext;
    List<DeviceInfo> deviceListData = new ArrayList<DeviceInfo>();
    private String ecServerId = "";
    private int receiveIntervalTime = 0;
    private String intervalString = "";
    private String intervalHex = "";
    Timer timer;
    private boolean timerIsStart;
    private int timerType = 0;
    private int outTimee = 0;
    private int outTimeBi = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zhimiBLEManager getInstance() {
        if (instance != null) return instance;
        Class<zhimiBLEManager> clazz = zhimiBLEManager.class;
        synchronized (zhimiBLEManager.class) {
            if (instance != null) return instance;
            instance = new zhimiBLEManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    @JSMethod
    public void setDataCallback(JSCallback jsCallback) {
        this.mDataCallback = jsCallback;
        ECBLE.getBLEWriteCallback((uuid, string, ok) -> {
            JSONObject object = new JSONObject();
            object.put("UUID", (Object)uuid);
            if (ok) {
                object.put("success", (Object)string);
            } else {
                object.put("error", (Object)string);
            }
            CallbackUtil.onKeepAliveCallback("didWriteValue", object, this.mDataCallback);
        });
        ECBLE.onBLECharacteristicValueChange((hex, string) -> {
            if (this.timerType == 1) {
                if (!this.timerIsStart) {
                    this.timerIsStart = true;
                    this.intervalHex = this.intervalHex + hex;
                    this.intervalString = this.intervalString + string;
                    this.timer = new Timer();
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            if (zhimiBLEManager.this.intervalHex.length() > 0 && zhimiBLEManager.this.intervalString.length() > 0) {
                                JSONObject object = new JSONObject();
                                object.put("hex", (Object)zhimiBLEManager.this.intervalHex);
                                object.put("string", (Object)zhimiBLEManager.this.intervalString);
                                CallbackUtil.onKeepAliveCallback("didUpdateValue", object, zhimiBLEManager.this.mDataCallback);
                                zhimiBLEManager.this.intervalHex = "";
                                zhimiBLEManager.this.intervalString = "";
                            }
                        }
                    };
                    this.timer.schedule(task, this.receiveIntervalTime, (long)this.receiveIntervalTime);
                } else {
                    this.intervalHex = this.intervalHex + hex;
                    this.intervalString = this.intervalString + string;
                }
            } else if (this.timerType == 2) {
                if (!this.timerIsStart) {
                    CallbackUtil.onKeepAliveCallback("startUpdateValue", null, this.mDataCallback);
                    this.timerIsStart = true;
                    this.intervalHex = this.intervalHex + hex;
                    this.intervalString = this.intervalString + string;
                    this.timer = new Timer();
                    TimerTask task = new TimerTask(){

                        @Override
                        public void run() {
                            if (zhimiBLEManager.this.outTimee > zhimiBLEManager.this.outTimeBi) {
                                zhimiBLEManager.this.outTimeBi++;
                            } else {
                                JSONObject object = new JSONObject();
                                object.put("hex", (Object)zhimiBLEManager.this.intervalHex);
                                object.put("string", (Object)zhimiBLEManager.this.intervalString);
                                CallbackUtil.onKeepAliveCallback("didUpdateValue", object, zhimiBLEManager.this.mDataCallback);
                                zhimiBLEManager.this.intervalHex = "";
                                zhimiBLEManager.this.intervalString = "";
                                zhimiBLEManager.this.timer.cancel();
                                zhimiBLEManager.this.outTimeBi = 0;
                                zhimiBLEManager.this.timerIsStart = false;
                            }
                        }
                    };
                    this.timer.schedule(task, 0L, 1L);
                } else {
                    this.intervalHex = this.intervalHex + hex;
                    this.intervalString = this.intervalString + string;
                }
            } else {
                JSONObject object = new JSONObject();
                object.put("hex", (Object)hex);
                object.put("string", (Object)string);
                CallbackUtil.onKeepAliveCallback("didUpdateValue", object, this.mDataCallback);
            }
        });
        ECBLE.onBLEConnectionStateChange(ok -> CallbackUtil.onKeepAliveCallback("onBLEConnectionStateChange", ok, this.mDataCallback));
    }

    public void initBLE() {
        int res = ECBLE.bluetoothAdapterInit(this.mContext);
        CallbackUtil.onKeepAliveCallback("onBLEStatus", res, this.mDataCallback);
    }

    public void startBluetoothDevicesDiscovery() {
        ECBLE.startBluetoothDevicesDiscovery((name, rssi) -> {
            JSONObject object = new JSONObject();
            object.put("name", (Object)name);
            object.put("rssi", (Object)rssi);
            boolean isExist = false;
            for (DeviceInfo item : this.deviceListData) {
                if (!item.name.equals(name)) continue;
                item.rssi = rssi;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.deviceListData.add(new DeviceInfo(name, rssi));
            }
            CallbackUtil.onKeepAliveCallback("onDeviceFounded", object, this.mDataCallback);
        });
    }

    public void stopBluetoothDevicesDiscovery() {
        ECBLE.stopBluetoothDevicesDiscovery();
    }

    public void connect(String name) {
        ECBLE.easyConnect(this.mContext, name, (ok, errCode) -> {
            if (ok) {
                CallbackUtil.onKeepAliveCallback("onConnectSuccess", "", this.mDataCallback);
            } else if (errCode == 0) {
                CallbackUtil.onKeepAliveCallback("onDisconnect", errCode, this.mDataCallback);
            } else {
                CallbackUtil.onKeepAliveCallback("onConnectFailed", errCode, this.mDataCallback);
            }
        });
    }

    public void disconnect() {
        ECBLE.offBLEConnectionStateChange();
        ECBLE.closeBLEConnection();
        this.timerIsStart = false;
    }

    public void discoverServices() {
        ECBLE.getBLEDeviceServices(servicesList -> {
            JSONObject object = new JSONObject();
            object.put("services", (Object)servicesList);
            CallbackUtil.onKeepAliveCallback("didDiscoverServices", object, this.mDataCallback);
        });
    }

    public void discoverCharacteristics(String service) {
        this.ecServerId = service;
        List<String> list = ECBLE.getBLEDeviceCharacteristics(service);
        JSONObject object = new JSONObject();
        object.put("characteristics", list);
        CallbackUtil.onKeepAliveCallback("didDiscoverCharacteristicsForService", object, this.mDataCallback);
    }

    public void setNotifyValueforCharacteristic(String value) {
        boolean ok = ECBLE.notifyBLECharacteristicValueChange(this.ecServerId, value);
        JSONObject object = new JSONObject();
        if (ok) {
            object.put("value", (Object)"success");
        } else {
            object.put("error", (Object)"false");
        }
        CallbackUtil.onKeepAliveCallback("didUpdateNotificationStateForCharacteristic", object, this.mDataCallback);
    }

    public void writeValue(String characteristic, boolean isHex, String value, int writeType) {
        ECBLE.writeBLECharacteristicValueType(this.ecServerId, characteristic, value, isHex, writeType);
    }

    public void setReceiveIntervalTime(int time) {
        this.receiveIntervalTime = time;
    }

    public void resetReceiveIntervalTime(int time) {
        this.receiveIntervalTime = time;
        this.timerIsStart = false;
        this.timer.cancel();
    }

    public void setReceiveType(int type) {
        this.timerType = type;
    }

    public void setOutTime(int time) {
        this.outTimee = time;
    }

    static class DeviceInfo {
        String name;
        int rssi;

        DeviceInfo(String name, int rssi) {
            this.name = name;
            this.rssi = rssi;
        }
    }
}

