/*
 * Decompiled with CFR 0.152.
 */
package com.example.zhimible;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.util.Log;
import com.example.zhimible.CharacteristicChangedCallback;
import com.example.zhimible.CharacteristicWriteCallback;
import com.example.zhimible.ConnectCallback;
import com.example.zhimible.ConnectionStateChangeCallback;
import com.example.zhimible.GetServicesCallback;
import com.example.zhimible.ScanCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ECBLE {
    static List<BLEDevice> deviceList = new ArrayList<BLEDevice>();
    static BluetoothAdapter bluetoothAdapter = null;
    static ScanCallback scanCallback = (name, rssi) -> {};
    static BluetoothAdapter.LeScanCallback leScanCallback = (bluetoothDevice, rssi, bytes) -> {
        Log.e((String)"bleDiscovery", (String)(bluetoothDevice.getName() + "|" + rssi));
        if (bluetoothDevice.getName() == null) {
            return;
        }
        boolean isExist = false;
        for (BLEDevice item : deviceList) {
            if (!item.name.equals(bluetoothDevice.getName())) continue;
            item.rssi = rssi;
            item.bluetoothDevice = bluetoothDevice;
            isExist = true;
            break;
        }
        if (!isExist) {
            deviceList.add(new BLEDevice(bluetoothDevice.getName(), rssi, bluetoothDevice));
        }
        scanCallback.callback(bluetoothDevice.getName(), rssi);
    };
    static boolean scanFlag = false;
    static BluetoothGatt bluetoothGatt = null;
    static BluetoothGattCallback bluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            Log.e((String)"onConnectionStateChange", (String)("status=" + status + "|newState=" + newState));
            if (status != 0) {
                connectCallback.callback(false, status);
                connectCallback = (ok, errCode) -> {};
                connectionStateChangeCallback.callback(false);
                return;
            }
            if (newState == 2) {
                ECBLE.stopBluetoothDevicesDiscovery();
                connectCallback.callback(true, 0);
                return;
            }
            if (newState == 0) {
                bluetoothGatt.close();
                connectCallback.callback(false, 0);
                connectionStateChangeCallback.callback(false);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            bluetoothGatt = gatt;
            List bluetoothGattServices = gatt.getServices();
            ArrayList<String> servicesList = new ArrayList<String>();
            if (bluetoothGattServices == null) {
                getServicesCallback.callback(servicesList);
            } else {
                for (BluetoothGattService item : bluetoothGattServices) {
                    Log.e((String)"ble-service", (String)("UUID=:" + item.getUuid().toString()));
                    servicesList.add(item.getUuid().toString());
                }
                getServicesCallback.callback(servicesList);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            byte[] bytes = characteristic.getValue();
            if (bytes != null) {
                Log.e((String)"ble-receive", (String)("\u8bfb\u53d6\u6210\u529f[hex]:" + ECBLE.bytesToHexString(bytes)));
                Log.e((String)"ble-receive", (String)("\u8bfb\u53d6\u6210\u529f[string]:" + new String(bytes)));
                characteristicChangedCallback.callback(ECBLE.bytesToHexString(bytes), new String(bytes));
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            if (0 == status) {
                Log.e((String)"BLEService", (String)("onMtuChanged success MTU = " + mtu));
            } else {
                Log.e((String)"BLEService", (String)"onMtuChanged fail ");
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            try {
                super.onCharacteristicWrite(gatt, characteristic, status);
                if (status != 0) {
                    characteristicWriteCallback.callback(characteristic.getUuid().toString(), "success", true);
                } else {
                    characteristicWriteCallback.callback(characteristic.getUuid().toString(), "error", false);
                }
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
    };
    static ConnectCallback connectCallback = (ok, errCode) -> {};
    static int reconnectTime = 0;
    static ConnectionStateChangeCallback connectionStateChangeCallback = ok -> {};
    static GetServicesCallback getServicesCallback = servicesList -> {};
    static CharacteristicChangedCallback characteristicChangedCallback = (hex, string) -> {};
    static CharacteristicWriteCallback characteristicWriteCallback = (uuid, string, ok) -> {};
    static String ecServerId = "0000FFF0-0000-1000-8000-00805F9B34FB";
    static String ecWriteCharacteristicId = "0000FFF2-0000-1000-8000-00805F9B34FB";
    static String ecReadCharacteristicId = "0000FFF1-0000-1000-8000-00805F9B34FB";

    private static boolean isLocServiceEnable(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        boolean gps = locationManager.isProviderEnabled("gps");
        boolean network = locationManager.isProviderEnabled("network");
        return gps || network;
    }

    public static int bluetoothAdapterInit(Context context) {
        if (bluetoothAdapter == null) {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (bluetoothGatt != null) {
            bluetoothGatt.close();
        }
        if (bluetoothAdapter == null) {
            return 1;
        }
        if (!ECBLE.isLocServiceEnable(context)) {
            return 2;
        }
        if (!ECBLE.getBluetoothAdapterState()) {
            ECBLE.openBluetoothAdapter();
            return 3;
        }
        return 0;
    }

    static void openBluetoothAdapter() {
        if (bluetoothAdapter != null) {
            bluetoothAdapter.enable();
        }
    }

    static void closeBluetoothAdapter() {
        if (bluetoothAdapter != null) {
            bluetoothAdapter.disable();
        }
    }

    static boolean getBluetoothAdapterState() {
        if (bluetoothAdapter == null) {
            return false;
        }
        return bluetoothAdapter.isEnabled();
    }

    static void startBluetoothDevicesDiscovery(ScanCallback cb) {
        scanCallback = cb;
        if (!scanFlag) {
            bluetoothAdapter.startLeScan(leScanCallback);
            scanFlag = true;
        }
    }

    static void stopBluetoothDevicesDiscovery() {
        if (scanFlag) {
            bluetoothAdapter.stopLeScan(leScanCallback);
            scanFlag = false;
        }
    }

    private static void createBLEConnection(Context context, String name, ConnectCallback cb) {
        connectCallback = cb;
        boolean isExist = false;
        for (BLEDevice item : deviceList) {
            if (!item.name.equals(name)) continue;
            bluetoothGatt = item.bluetoothDevice.connectGatt(context, false, bluetoothGattCallback);
            isExist = true;
            break;
        }
        if (!isExist) {
            connectCallback.callback(false, -1);
        }
    }

    static void closeBLEConnection() {
        bluetoothGatt.disconnect();
    }

    static void getBLEDeviceServices(GetServicesCallback cb) {
        getServicesCallback = cb;
        bluetoothGatt.discoverServices();
    }

    static List<String> getBLEDeviceCharacteristics(String serviceId) {
        BluetoothGattService service = bluetoothGatt.getService(UUID.fromString(serviceId));
        List listGattCharacteristic = service.getCharacteristics();
        ArrayList<String> characteristicsList = new ArrayList<String>();
        if (listGattCharacteristic == null) {
            return characteristicsList;
        }
        for (BluetoothGattCharacteristic item : listGattCharacteristic) {
            Log.e((String)"ble-characteristic", (String)("UUID=:" + item.getUuid().toString()));
            characteristicsList.add(item.getUuid().toString());
        }
        return characteristicsList;
    }

    static boolean notifyBLECharacteristicValueChange(String serviceId, String characteristicId) {
        BluetoothGattService service = bluetoothGatt.getService(UUID.fromString(serviceId));
        if (service == null) {
            return false;
        }
        BluetoothGattCharacteristic characteristicRead = service.getCharacteristic(UUID.fromString(characteristicId));
        boolean res = bluetoothGatt.setCharacteristicNotification(characteristicRead, true);
        if (!res) {
            return false;
        }
        for (BluetoothGattDescriptor dp : characteristicRead.getDescriptors()) {
            dp.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            bluetoothGatt.writeDescriptor(dp);
        }
        return true;
    }

    static void onBLECharacteristicValueChange(CharacteristicChangedCallback cb) {
        characteristicChangedCallback = cb;
    }

    static void getBLEWriteCallback(CharacteristicWriteCallback cb) {
        characteristicWriteCallback = cb;
    }

    static void easyOneConnect(Context context, String name, ConnectCallback cb) {
        ECBLE.createBLEConnection(context, name, (ok, errCode) -> {
            Log.e((String)"Connection", (String)("res:" + ok + "|" + errCode));
            if (ok) {
                cb.callback(true, 0);
            } else {
                cb.callback(false, 0);
            }
        });
    }

    static void easyConnect(Context context, String name, ConnectCallback cb) {
        ECBLE.easyOneConnect(context, name, (ok, errCode) -> {
            if (ok) {
                reconnectTime = 0;
                cb.callback(true, 0);
            } else {
                cb.callback(false, 0);
            }
        });
    }

    static void onBLEConnectionStateChange(ConnectionStateChangeCallback cb) {
        connectionStateChangeCallback = cb;
    }

    static void offBLEConnectionStateChange() {
        connectionStateChangeCallback = ok -> {};
    }

    static void writeBLECharacteristicValue(String serviceId, String characteristicId, String data, boolean isHex) {
        byte[] byteArray = isHex ? ECBLE.toByteArray(data) : data.getBytes();
        BluetoothGattService service = bluetoothGatt.getService(UUID.fromString(serviceId));
        BluetoothGattCharacteristic characteristicWrite = service.getCharacteristic(UUID.fromString(characteristicId));
        characteristicWrite.setValue(byteArray);
        characteristicWrite.setWriteType(1);
        bluetoothGatt.writeCharacteristic(characteristicWrite);
    }

    static void writeBLECharacteristicValueType(String serviceId, String characteristicId, String data, boolean isHex, int writeType) {
        byte[] byteArray = isHex ? ECBLE.toByteArray(data) : data.getBytes();
        BluetoothGattService service = bluetoothGatt.getService(UUID.fromString(serviceId));
        BluetoothGattCharacteristic characteristicWrite = service.getCharacteristic(UUID.fromString(characteristicId));
        characteristicWrite.setValue(byteArray);
        if (writeType == 0) {
            characteristicWrite.setWriteType(2);
        } else {
            characteristicWrite.setWriteType(1);
        }
        bluetoothGatt.writeCharacteristic(characteristicWrite);
    }

    static void easySendData(String data, boolean isHex) {
        ECBLE.writeBLECharacteristicValue(ecServerId, ecWriteCharacteristicId, data, isHex);
    }

    static void setMtu(int v) {
        if (Build.VERSION.SDK_INT >= 21) {
            bluetoothGatt.requestMtu(v);
        }
    }

    static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (byte b : bytes) {
            str.append(String.format("%02X", b));
        }
        return str.toString();
    }

    static byte[] toByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    static class BLEDevice {
        String name;
        int rssi;
        BluetoothDevice bluetoothDevice;

        BLEDevice(String name, int rssi, BluetoothDevice bluetoothDevice) {
            this.name = name;
            this.rssi = rssi;
            this.bluetoothDevice = bluetoothDevice;
        }
    }
}

