/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.xj.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.opera.vo.QgOperaBeforeVO;
import io.huimu.modules.outside.vo.WxXjVO;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.wx.service.WxPushLogService;
import io.huimu.modules.wx.service.WxService;
import io.huimu.modules.xj.dao.XjDao;
import io.huimu.modules.xj.dto.XjDTO;
import io.huimu.modules.xj.entity.XjEntity;
import io.huimu.modules.xj.service.XjService;
import io.huimu.modules.xj.vo.XjVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XjServiceImpl
extends BaseServiceImpl<XjDao, XjEntity>
implements XjService {
    @Autowired
    private WxService wxService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private WxPushLogService wxPushLogService;

    public void insert(XjDTO dto) {
        XjEntity preachEntity = (XjEntity)ConvertUtils.sourceToTarget((Object)dto, XjEntity.class);
        this.insert((Object)preachEntity);
    }

    public XjDTO get(String id) {
        return (XjDTO)ConvertUtils.sourceToTarget((Object)((XjDao)this.baseDao).selectById((Serializable)((Object)id)), XjDTO.class);
    }

    public List<XjVO> getPreachList() {
        List preachEntities = ((XjDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().orderByAsc((Object)"SORT_INDEX")).orderByDesc((Object)"UPDATE_DATE"));
        List preachVOList = ConvertUtils.sourceToTarget((Collection)preachEntities, XjVO.class);
        return preachVOList;
    }

    public void update(XjDTO dto) {
        XjEntity XjEntity2 = (XjEntity)ConvertUtils.sourceToTarget((Object)dto, XjEntity.class);
        this.updateById((Object)XjEntity2);
    }

    public List<XjEntity> getListByNodeAndTitle(String node, String title) {
        return ((XjDao)this.baseDao).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"NODE", (Object)node)).like((Object)"TITLE", (Object)title));
    }

    @Transactional(rollbackFor={Exception.class})
    @Async
    public void operaPreachPush(QgOperaBeforeVO info, String node, String title, Integer sendType) {
        String messageId = this.sysSystemConfService.getConfValue("100044", null);
        if (StringUtils.isBlank((CharSequence)messageId)) {
            System.out.println("\u5fae\u4fe1\u6d88\u606f\u6a21\u677f\u4e3a\u7a7a");
            return;
        }
        List preachList = this.getListByNodeAndTitle(node, title);
        HashSet<XjEntity> pushSet = new HashSet<XjEntity>();
        if (CollUtil.isNotEmpty((Collection)preachList)) {
            block0: for (XjEntity preachEntity : preachList) {
                String[] remarks;
                if (!StringUtils.isNotEmpty((CharSequence)preachEntity.getRemark())) continue;
                for (String remark : remarks = preachEntity.getRemark().split(",")) {
                    if (!info.getOperaName().contains(remark)) continue;
                    pushSet.add(preachEntity);
                    continue block0;
                }
            }
        }
        if (CollUtil.isNotEmpty(pushSet)) {
            for (XjEntity xjEntity : pushSet) {
                Map wxParam = this.wxService.getSendWxMsgParam(info.getOrgName(), info.getPatientName(), "\u606d\u559c\u60a8\u987a\u5229\u5b8c\u6210\u6b64\u6b21\u624b\u672f\uff0c\u4e3a\u4e86\u672f\u540e\u7684\u5feb\u901f\u5eb7\u590d\uff0c\u8bf7\u70b9\u51fb\u8be6\u60c5\uff0c\u67e5\u770b\u672f\u540e\u5ba3\u6559\u5185\u5bb9");
                this.wxService.sendMessage(messageId, wxParam, info.getPatientIdNumber(), xjEntity.getUrl(), sendType, xjEntity.getTitle(), xjEntity.getXjName());
            }
        }
    }

    public List<WxXjVO> getWxXjList(String patientIdNumber, Integer type) {
        if (StringUtils.isNotBlank((CharSequence)patientIdNumber)) {
            return this.wxPushLogService.getWxXjList(patientIdNumber, type);
        }
        return ((XjDao)this.baseDao).getWxXjList(type);
    }
}

