/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.xj.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.xj.dto.XjDTO;
import io.huimu.modules.xj.entity.XjEntity;
import io.huimu.modules.xj.service.XjService;
import io.huimu.modules.xj.vo.XjVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/xj"})
@Api(tags={"\u5ba3\u6559\u7ba1\u7406"})
public class XjController {
    @Autowired
    private XjService xjService;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u589e\u52a0\u5ba3\u6559")
    @LogOperation(value="\u4fee\u6539\u5ba3\u6559", module="\u5ba3\u6559\u7ba1\u7406", operationType=1)
    public Result insert(@RequestBody EncryptedReq<XjDTO> req) {
        XjDTO dto = (XjDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.xjService.insert(ConvertUtils.sourceToTarget((Object)dto, XjEntity.class));
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u5ba3\u6559")
    @LogOperation(value="\u5220\u9664\u5ba3\u6559", module="\u5ba3\u6559\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.xjService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u5ba3\u6559")
    @LogOperation(value="\u4fee\u6539\u5ba3\u6559", module="\u5ba3\u6559\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=XjDTO.class)
    public Result update(@RequestBody EncryptedReq<XjDTO> req) {
        XjDTO dto = (XjDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.xjService.updateById(ConvertUtils.sourceToTarget((Object)dto, XjEntity.class));
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u67e5\u627e\u5ba3\u6559")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        XjEntity entity = (XjEntity)this.xjService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, XjDTO.class));
    }

    @PostMapping(value={"getXjList"})
    @ApiOperation(value="\u83b7\u53d6\u5ba3\u6559\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<List<XjVO>> getXjList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.xjService.getPreachList();
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

