/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.websocket;

import com.alibaba.fastjson.JSON;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.websocket.config.WebSocketConfig;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{deviceId}", configurator=WebSocketConfig.class)
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static ConcurrentHashMap<String, CopyOnWriteArraySet<Session>> webSocketMap = new ConcurrentHashMap();
    private String deviceId = "";

    @OnOpen
    public void open(Session session, @PathParam(value="deviceId") String deviceId) {
        CopyOnWriteArraySet<Session> currentSession;
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + deviceId + "\uff0c\u5df2\u8fde\u63a5");
            currentSession = (CopyOnWriteArraySet<Session>)webSocketMap.get(deviceId);
            if (null == currentSession) {
                currentSession = new CopyOnWriteArraySet<Session>();
            }
        } else {
            throw new RenException("\u8bbe\u5907ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fde\u63a5");
        }
        this.deviceId = deviceId;
        currentSession.add(session);
        webSocketMap.put(deviceId, currentSession);
        System.out.println("\u8bbe\u5907id\uff1a" + deviceId + ",open\uff0c\u8fde\u63a5\u6570\uff1a" + currentSession.size());
    }

    @OnClose
    public void onClose(Session session) {
        System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + this.deviceId + "\uff0c\u5df2\u65ad\u5f00\u8fde\u63a5");
        CopyOnWriteArraySet currentSession = (CopyOnWriteArraySet)webSocketMap.get(this.deviceId);
        if (null == currentSession || currentSession.size() == 0) {
            System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + this.deviceId + "\uff0c\u5df2\u65ad\u5f00\u8fde\u63a5\uff0c\u6ca1\u6709session\u6d88\u606f");
            return;
        }
        currentSession.remove(session);
        System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + this.deviceId + "\uff0c\u5df2\u65ad\u5f00\u8fde\u63a5");
        System.out.println("\u8bbe\u5907id\uff1a" + this.deviceId + ",onClose\uff0c\u8fde\u63a5\u6570\uff1a" + currentSession.size());
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + this.deviceId + "\uff0c\u8fde\u63a5\u62a5\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + throwable.getMessage());
        CopyOnWriteArraySet currentSession = (CopyOnWriteArraySet)webSocketMap.get(this.deviceId);
        if (null == currentSession || currentSession.size() == 0) {
            return;
        }
        currentSession.remove(session);
        log.error(throwable.getMessage(), throwable);
    }

    @OnMessage
    public void onMessage(@PathParam(value="deviceId") String deviceId, String msg) {
        this.sendMessage(deviceId, (Object)msg);
    }

    public void sendMessage(String deviceId, Object message) {
        if (StringUtils.isNotBlank((CharSequence)deviceId)) {
            CopyOnWriteArraySet currentSession = (CopyOnWriteArraySet)webSocketMap.get(deviceId);
            if (null == currentSession || currentSession.size() == 0) {
                System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + deviceId + "\uff0c\u6ca1\u6709session\u6d88\u606f");
                return;
            }
            System.out.println("\u8bbe\u5907id\uff1a" + deviceId + ",\u8fde\u63a5\u6570\uff1a" + currentSession.size());
            for (Session session : currentSession) {
                System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u8bbe\u5907ID:" + deviceId + "session\u4fe1\u606f\uff1a" + session + "\uff0c\u53d1\u9001\u6d88\u606f" + JSON.toJSONString((Object)message));
                this.sendMessage(session, message);
            }
        } else {
            throw new RenException("\u8bbe\u5907ID\u4e3a\u7a7a,\u65e0\u6cd5\u63a8\u9001\u4fe1\u606f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Session session, Object message) {
        try {
            Session session2 = session;
            synchronized (session2) {
                session.getBasicRemote().sendText(new GsonBuilder().setLongSerializationPolicy(LongSerializationPolicy.STRING).create().toJson(message));
            }
        }
        catch (IOException e) {
            log.error("send message error\uff0c" + e.getMessage(), (Throwable)e);
        }
    }
}

