/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.visit.dao.VisitPatientDao;
import io.huimu.modules.visit.dao.VisitTargetDao;
import io.huimu.modules.visit.dto.SfCountDTO;
import io.huimu.modules.visit.dto.VisitTargetDTO;
import io.huimu.modules.visit.dto.add.BindPatientDTO;
import io.huimu.modules.visit.entity.VisitPatientEntity;
import io.huimu.modules.visit.entity.VisitTargetEntity;
import io.huimu.modules.visit.service.VisitPatientService;
import io.huimu.modules.visit.vo.VisitListInfoVO;
import io.huimu.modules.visit.vo.VisitSendSmsVO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisitPatientServiceImpl
extends BaseServiceImpl<VisitPatientDao, VisitPatientEntity>
implements VisitPatientService {
    @Autowired
    private VisitTargetDao targetDao;

    @Transactional(rollbackFor={Exception.class})
    public Result saveOrUpdateVisitPatient(BindPatientDTO dto) {
        ((VisitPatientDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)dto.getPatientId())).eq((Object)"org_code", (Object)dto.getOrgCode()));
        VisitPatientEntity entity = (VisitPatientEntity)ConvertUtils.sourceToTarget((Object)dto, VisitPatientEntity.class);
        entity.setEmployeeId(SecurityUser.getEmployeeId());
        entity.setEmployeeName(SecurityUser.getUser().getRealName());
        this.insert((Object)entity);
        return new Result();
    }

    public List<VisitSendSmsVO> getVisitSendList(String orgCode) {
        return ((VisitPatientDao)this.baseDao).getVisitSendList(orgCode);
    }

    public void updateSendInfo(String id, Integer sendFlag) {
        VisitPatientEntity entity = new VisitPatientEntity();
        entity.setId(id);
        entity.setSendFlag(sendFlag);
        entity.setSendDate(new Date());
        this.updateById((Object)entity);
    }

    public PageData<VisitListInfoVO> sfList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "employeeName"});
        if (params.get("type") == null) {
            return null;
        }
        List list = ((VisitPatientDao)this.baseDao).sfList(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageData(list, 0L);
        }
        int total = list.size();
        long curPage = 1L;
        long limit = 10L;
        if (params.get("page") != null) {
            curPage = Long.parseLong((String)params.get("page"));
        }
        if (params.get("limit") != null) {
            limit = Long.parseLong((String)params.get("limit"));
        }
        list = list.stream().skip((curPage - 1L) * limit).limit(limit).collect(Collectors.toList());
        return new PageData(list, (long)total);
    }

    public void deleteByPid(String patientId, String orgCode) {
        ((VisitPatientDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)patientId)).eq((Object)"org_code", (Object)orgCode));
    }

    public Result bindVisitTarget(VisitTargetDTO dto) {
        this.targetDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)dto.getPatientId())).eq((Object)"org_code", (Object)dto.getOrgCode()));
        VisitTargetEntity entity = (VisitTargetEntity)ConvertUtils.sourceToTarget((Object)dto, VisitTargetEntity.class);
        this.targetDao.insert((Object)entity);
        return new Result();
    }

    public void cancelTarget(String patientId, String orgCode) {
        this.targetDao.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)patientId)).eq((Object)"org_code", (Object)orgCode));
    }

    public VisitTargetDTO getTarget(String patientId, String orgCode) {
        VisitTargetEntity entity = (VisitTargetEntity)this.targetDao.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)patientId)).eq((Object)"org_code", (Object)orgCode));
        return (VisitTargetDTO)ConvertUtils.sourceToTarget((Object)entity, VisitTargetDTO.class);
    }

    public SfCountDTO sfCount(String orgCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("orgCode", orgCode);
        ((VisitPatientDao)this.baseDao).sfCount(param);
        SfCountDTO dto = new SfCountDTO();
        dto.setTotal(Integer.valueOf(param.get("total").toString()));
        dto.setDhsfCount(Integer.valueOf(param.get("dhsfTotal").toString()));
        dto.setMzsfCount(Integer.valueOf(param.get("mzsfTotal").toString()));
        dto.setSfPercent(param.get("sfPercent").toString());
        return dto;
    }

    public BindPatientDTO getPatientVisitInfo(String patientId, String orgCode) {
        VisitPatientEntity entity = (VisitPatientEntity)((VisitPatientDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)patientId)).eq((Object)"org_code", (Object)orgCode));
        return (BindPatientDTO)ConvertUtils.sourceToTarget((Object)entity, BindPatientDTO.class);
    }
}

