/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.visit.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.visit.dto.SfCountDTO;
import io.huimu.modules.visit.dto.VisitTargetDTO;
import io.huimu.modules.visit.dto.add.BindPatientDTO;
import io.huimu.modules.visit.param.CancelBindParam;
import io.huimu.modules.visit.param.CancelTargetParam;
import io.huimu.modules.visit.param.GetPatientVisitParam;
import io.huimu.modules.visit.param.GetSfCountParam;
import io.huimu.modules.visit.param.GetSfListParam;
import io.huimu.modules.visit.param.GetTargetParam;
import io.huimu.modules.visit.service.VisitPatientService;
import io.huimu.modules.visit.vo.VisitListInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"visit/patient"})
@Api(tags={"\u968f\u8bbf-\u60a3\u8005\u7ba1\u7406"})
public class VisitPatientController {
    @Autowired
    private VisitPatientService visitPatientService;

    @PostMapping(value={"bindPat"})
    @ApiOperation(value="\u65b9\u6848-\u7ed1\u5b9a\u60a3\u8005")
    @LogOperation(value="\u7ed1\u5b9a\u60a3\u8005\u968f\u8bbf\u65b9\u6848", module="\u968f\u8bbf-\u60a3\u8005\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=BindPatientDTO.class)
    public Result saveVisitPatient(@RequestBody EncryptedReq<BindPatientDTO> req) {
        BindPatientDTO dto = (BindPatientDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.visitPatientService.saveOrUpdateVisitPatient(dto);
    }

    @PostMapping(value={"sfList"})
    @ApiOperation(value="\u968f\u8bbf\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetSfListParam.class)
    public Result<PageData<VisitListInfoVO>> page(@RequestBody EncryptedReq<GetSfListParam> req) throws IllegalAccessException {
        GetSfListParam params = (GetSfListParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        return new Result().ok(req.getEncode(), (Object)this.visitPatientService.sfList(MapUtils.object2Map((Object)params)));
    }

    @PostMapping(value={"cancelBind"})
    @ApiOperation(value="\u53d6\u6d88\u7ed1\u5b9a\u968f\u8bbf\u65b9\u6848")
    @LogOperation(value="\u53d6\u6d88\u7ed1\u5b9a\u968f\u8bbf\u65b9\u6848", module="\u968f\u8bbf-\u60a3\u8005\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=CancelBindParam.class)
    public Result cancelBind(@RequestBody EncryptedReq<CancelBindParam> req) {
        CancelBindParam dto = (CancelBindParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.visitPatientService.deleteByPid(dto.getPatientId(), dto.getOrgCode());
        return new Result();
    }

    @PostMapping(value={"bindVisitTarget"})
    @ApiOperation(value="\u7ed1\u5b9a\u60a3\u8005\u968f\u8bbf\u6307\u6807")
    @LogOperation(value="\u7ed1\u5b9a\u60a3\u8005\u968f\u8bbf\u6307\u6807", module="\u968f\u8bbf-\u60a3\u8005\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=VisitTargetDTO.class)
    public Result bindVisitTarget(@RequestBody EncryptedReq<VisitTargetDTO> req) {
        VisitTargetDTO dto = (VisitTargetDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.visitPatientService.bindVisitTarget(dto);
    }

    @PostMapping(value={"cancelTarget"})
    @ApiOperation(value="\u53d6\u6d88\u7ed1\u5b9a\u968f\u8bbf\u6307\u6807")
    @LogOperation(value="\u53d6\u6d88\u7ed1\u5b9a\u968f\u8bbf\u6307\u6807", module="\u968f\u8bbf-\u60a3\u8005\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=CancelTargetParam.class)
    public Result cancelTarget(@RequestBody EncryptedReq<CancelTargetParam> req) {
        CancelTargetParam param = (CancelTargetParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        this.visitPatientService.cancelTarget(param.getPatientId(), param.getOrgCode());
        return new Result();
    }

    @PostMapping(value={"getTarget"})
    @ApiOperation(value="\u83b7\u53d6\u7ed1\u5b9a\u968f\u8bbf\u6307\u6807")
    @DecryptAndVerify(decryptedClass=GetTargetParam.class)
    public Result getTarget(@RequestBody EncryptedReq<GetTargetParam> req) {
        GetTargetParam param = (GetTargetParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        VisitTargetDTO dto = this.visitPatientService.getTarget(param.getPatientId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"getPatientVisitInfo"})
    @ApiOperation(value="\u83b7\u53d6\u7ed1\u5b9a\u968f\u8bbf\u6307\u6807")
    @DecryptAndVerify(decryptedClass=GetPatientVisitParam.class)
    public Result getPatientVisitInfo(@RequestBody EncryptedReq<GetPatientVisitParam> req) {
        GetPatientVisitParam param = (GetPatientVisitParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        BindPatientDTO dto = this.visitPatientService.getPatientVisitInfo(param.getPatientId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"sfCount"})
    @ApiOperation(value="\u968f\u8bbf\u7edf\u8ba1")
    @DecryptAndVerify(decryptedClass=GetSfCountParam.class)
    public Result<SfCountDTO> sfCount(@RequestBody EncryptedReq<GetSfCountParam> req) {
        GetSfCountParam param = (GetSfCountParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        SfCountDTO dto = this.visitPatientService.sfCount(param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }
}

