/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.upload.service.impl;

import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.HtmlToPdfUtil;
import io.huimu.common.utils.Result;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.dao.UploadDao;
import io.huimu.modules.upload.dto.ContentDTO;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.service.UploadService;
import java.io.IOException;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UploadServiceImpl
extends BaseServiceImpl<UploadDao, UploadEntity>
implements UploadService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public Result uploadFile(MultipartFile file) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity entity = FileUtils.upload((MultipartFile)file, (String)ftpPath, (String)"upload_file");
        return new Result().ok((Object)entity);
    }

    public Result uploadEmrPdf(MultipartFile file, String patientId) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity entity = FileUtils.uploadEmrPdf((MultipartFile)file, (String)ftpPath, (String)("emr_pdf/" + patientId));
        return new Result().ok((Object)entity);
    }

    public UploadEntity uploadFileWithPath(MultipartFile file, String path) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity entity = FileUtils.upload((MultipartFile)file, (String)ftpPath, (String)(StringUtils.isNotBlank((CharSequence)path) ? path : "upload_file"));
        return entity;
    }

    public UploadEntity writeToFile(ContentDTO dto) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity entity = FileUtils.writeToFile((String)dto.getContent(), (String)ftpPath, (String)("txt_file/" + dto.getPath()), null, (String)"txt");
        return entity;
    }

    public String getFileContent(String path) {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        return FileUtils.getFileContent((String)path, (String)ftpPath);
    }

    public String getFileBase(String path) {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        return FileUtils.fileToBase64Str((String)path, (String)ftpPath);
    }

    public UploadEntity baseToImage(ContentDTO dto) {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity entity = FileUtils.base64ToImg((String)dto.getContent(), (String)ftpPath, (String)("base_to_img/" + dto.getPath()));
        return entity;
    }

    public UploadEntity htmlToPdf(ContentDTO dto) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        dto.setContent(URLDecoder.decode(dto.getContent(), "UTF-8"));
        UploadEntity uploadEntity = HtmlToPdfUtil.html2Pdf((String)dto.getPageSize(), (String)dto.getContent(), (String)ftpPath, (String)("emr_pdf/" + dto.getPatientId()));
        FileUtils.writeToFile((String)dto.getContent(), (String)ftpPath, (String)("emr_pdf/" + dto.getPatientId()), (String)FileUtils.replaceEx((String)uploadEntity.getFileNewName(), (String)"txt"), (String)"txt");
        return uploadEntity;
    }

    public UploadEntity htmlToPdfTest(ContentDTO dto) throws IOException {
        String ftpPath = "C:\\ftp";
        dto.setContent(URLDecoder.decode(dto.getContent(), "UTF-8"));
        UploadEntity uploadEntity = HtmlToPdfUtil.html2Pdf((String)dto.getPageSize(), (String)dto.getContent(), (String)ftpPath, (String)("emr_pdf/" + dto.getPatientId()));
        return uploadEntity;
    }
}

