/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.upload.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.upload.dto.ContentDTO;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.param.GetFileContentParam;
import io.huimu.modules.upload.service.UploadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/upload"})
@Api(tags={"\u6587\u4ef6\u4e0a\u4f20\u7ba1\u7406"})
public class UploadController {
    @Autowired
    private UploadService uploadService;

    @PostMapping(value={"uploadFile"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    public Result uploadFile(@RequestPart(value="file", required=false) MultipartFile file) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uploadService.uploadFile(file);
    }

    @PostMapping(value={"uploadFileWithPath"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    public Result uploadFileWithPath(@RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="path") String path) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Result().ok((Object)this.uploadService.uploadFileWithPath(file, path));
    }

    @PostMapping(value={"writeToFile"})
    @ApiOperation(value="\u5185\u5bb9\u5199\u5165\u6587\u4ef6")
    @DecryptAndVerify(decryptedClass=ContentDTO.class)
    public Result writeToFile(@RequestBody EncryptedReq<ContentDTO> req) throws IOException {
        ContentDTO dto = (ContentDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        UploadEntity entity = this.uploadService.writeToFile(dto);
        return new Result().ok(req.getEncode(), (Object)entity);
    }

    @PostMapping(value={"getFileContent"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @DecryptAndVerify(decryptedClass=GetFileContentParam.class)
    public Result getFileContent(@RequestBody EncryptedReq<GetFileContentParam> req) {
        GetFileContentParam dto = (GetFileContentParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        String content = this.uploadService.getFileContent(dto.getPath());
        return new Result().ok(req.getEncode(), (Object)content);
    }

    @PostMapping(value={"uploadEmrPdf"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u7535\u5b50\u75c5\u5386pdf")
    public Result uploadEmrPdf(@RequestParam(value="file") MultipartFile file, @RequestPart(value="patientId") String patientId) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)patientId)) {
            return new Result().error("\u75c5\u5386\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uploadService.uploadEmrPdf(file, patientId);
    }

    @PostMapping(value={"htmlToPdf"})
    @ApiOperation(value="\u75c5\u5386html\u8f6cpdf")
    @DecryptAndVerify(decryptedClass=ContentDTO.class)
    public Result htmlToPdf(@RequestBody EncryptedReq<ContentDTO> req) throws Exception {
        ContentDTO dto = (ContentDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        UploadEntity uploadEntity = this.uploadService.htmlToPdf(dto);
        return new Result().ok(req.getEncode(), (Object)uploadEntity);
    }

    @PostMapping(value={"htmlToPdfTest"})
    @ApiOperation(value="\u75c5\u5386html\u8f6cpdf\u6d4b\u8bd5")
    @DecryptAndVerify(decryptedClass=ContentDTO.class)
    public Result htmlToPdfTest(@RequestBody EncryptedReq<ContentDTO> req) throws Exception {
        ContentDTO dto = (ContentDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        UploadEntity uploadEntity = this.uploadService.htmlToPdfTest(dto);
        return new Result().ok(req.getEncode(), (Object)uploadEntity);
    }

    @PostMapping(value={"getFileBase"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6base64")
    @DecryptAndVerify(decryptedClass=GetFileContentParam.class)
    public Result getFileBase(@RequestBody EncryptedReq<GetFileContentParam> req) {
        GetFileContentParam dto = (GetFileContentParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        String content = this.uploadService.getFileBase(dto.getPath());
        return new Result().ok(req.getEncode(), (Object)content);
    }
}

