/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.tag.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.dict.vo.DictTagVO;
import io.huimu.modules.tag.dao.DictTagDao;
import io.huimu.modules.tag.dto.DictTagDTO;
import io.huimu.modules.tag.entity.DictTagEntity;
import io.huimu.modules.tag.service.DictTagService;
import io.huimu.modules.tag.service.TagRelationService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTagServiceImpl
extends BaseServiceImpl<DictTagDao, DictTagEntity>
implements DictTagService {
    @Autowired
    private TagRelationService tagRelationService;

    public void saveTag(DictTagDTO dictTagDTO) {
        DictTagEntity entity = (DictTagEntity)ConvertUtils.sourceToTarget((Object)dictTagDTO, DictTagEntity.class);
        entity.setCreateDate(new Date());
        this.insert((Object)entity);
    }

    public void updateTag(DictTagDTO dictTagDTO) {
        DictTagEntity entity = (DictTagEntity)ConvertUtils.sourceToTarget((Object)dictTagDTO, DictTagEntity.class);
        entity.setCreateDate(new Date());
        this.updateById((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTag(String id) {
        Integer count = ((DictTagDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"PID", (Object)id));
        if (count > 0) {
            throw new RenException("\u5305\u542b\u5b50\u6807\u7b7e\uff0c\u5220\u9664\u5931\u8d25");
        }
        this.tagRelationService.deletePatientTagByTagId(id);
        this.tagRelationService.deleteExamItemTagByTagId(id);
        this.tagRelationService.deleteImageTagByTagId(id);
        ((DictTagDao)this.baseDao).deleteById((Serializable)((Object)id));
    }

    public List<DictTagVO> getTreeList() {
        List entityList = ((DictTagDao)this.baseDao).selectList((Wrapper)new QueryWrapper());
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)entityList, DictTagVO.class));
    }
}

