/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.tag.service;

import cn.hutool.core.collection.CollUtil;
import io.huimu.common.utils.IDUtils;
import io.huimu.modules.tag.dao.TagRelationDao;
import io.huimu.modules.tag.dto.SaveExamFileTagDTO;
import io.huimu.modules.tag.dto.SaveExamItemTagDTO;
import io.huimu.modules.tag.dto.SavePatientTagDTO;
import io.huimu.modules.tag.entity.ExamFilesTagEntity;
import io.huimu.modules.tag.entity.ExamItemTagEntity;
import io.huimu.modules.tag.entity.PatientTagEntity;
import io.huimu.modules.tag.param.DeleteTagRelationParam;
import io.huimu.modules.tag.vo.TagRelationVO;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TagRelationService {
    @Autowired
    private TagRelationDao tagRelationDao;

    @Transactional(rollbackFor={Exception.class})
    public void savePatientTag(SavePatientTagDTO dto) {
        List dbTags = this.tagRelationDao.getPatientTagIds(dto.getPatientId());
        HashSet stringSet = new HashSet();
        if (CollUtil.isNotEmpty((Collection)dto.getTagIds())) {
            stringSet.addAll(dto.getTagIds());
        }
        if (CollUtil.isNotEmpty((Collection)dbTags)) {
            stringSet.addAll(dbTags);
        }
        this.tagRelationDao.deletePatientTag(dto.getPatientId());
        if (CollUtil.isNotEmpty(stringSet)) {
            for (String tagId : stringSet) {
                PatientTagEntity entity = new PatientTagEntity();
                entity.setId(IDUtils.generateStringValue());
                entity.setPatientId(dto.getPatientId());
                entity.setTagId(tagId);
                this.tagRelationDao.savePatientTag(entity);
            }
        }
    }

    public List<TagRelationVO> getPatientTagList(String patientId) {
        return this.tagRelationDao.getPatientTagList(patientId);
    }

    public void deletePatientTagById(DeleteTagRelationParam param) {
        this.tagRelationDao.deletePatientTagById(param);
    }

    public void deletePatientTagByTagId(String tagId) {
        this.tagRelationDao.deletePatientTagByTagId(tagId);
    }

    public void deleteExamItemTagByTagId(String tagId) {
        this.tagRelationDao.deleteExamItemTagByTagId(tagId);
    }

    public void deleteImageTagByTagId(String tagId) {
        this.tagRelationDao.deleteImageTagByTagId(tagId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveExamItemTag(SaveExamItemTagDTO dto) {
        List dbTags = this.tagRelationDao.getExamItemTagIds(dto.getRisNo(), dto.getExamNo());
        HashSet stringSet = new HashSet();
        if (CollUtil.isNotEmpty((Collection)dto.getTagIds())) {
            stringSet.addAll(dto.getTagIds());
        }
        if (CollUtil.isNotEmpty((Collection)dbTags)) {
            stringSet.addAll(dbTags);
        }
        this.tagRelationDao.deleteExamItemTag(dto.getRisNo(), dto.getExamNo());
        if (CollUtil.isNotEmpty(stringSet)) {
            for (String tagId : stringSet) {
                ExamItemTagEntity entity = new ExamItemTagEntity();
                entity.setId(IDUtils.generateStringValue());
                entity.setRisNo(dto.getRisNo());
                entity.setExamNo(dto.getExamNo());
                entity.setTagId(tagId);
                this.tagRelationDao.saveExamItemTag(entity);
            }
        }
    }

    public void deleteExamItemTag(DeleteTagRelationParam param) {
        this.tagRelationDao.deleteExamItemTagById(param.getId());
    }

    public List<TagRelationVO> getExamItemTagList(String risNo, String examNo) {
        return this.tagRelationDao.getExamItemTagList(risNo, examNo);
    }

    public void saveExamFilesTag(SaveExamFileTagDTO dto) {
        List dbTags = this.tagRelationDao.getExamFilesTagIds(dto.getRecId());
        HashSet stringSet = new HashSet();
        if (CollUtil.isNotEmpty((Collection)dto.getTagIds())) {
            stringSet.addAll(dto.getTagIds());
        }
        if (CollUtil.isNotEmpty((Collection)dbTags)) {
            stringSet.addAll(dbTags);
        }
        this.tagRelationDao.deleteExamFilesTagByRecId(dto.getRecId());
        if (CollUtil.isNotEmpty(stringSet)) {
            for (String tagId : stringSet) {
                ExamFilesTagEntity entity = new ExamFilesTagEntity();
                entity.setId(IDUtils.generateStringValue());
                entity.setTagId(tagId);
                entity.setRecId(dto.getRecId());
                this.tagRelationDao.saveExamFilesTag(entity);
            }
        }
    }

    public void deleteExamFilesTag(String id) {
        this.tagRelationDao.deleteExamFilesTagById(id);
    }

    public List<TagRelationVO> getExamFilesTagList(String recId) {
        return this.tagRelationDao.getExamFilesTagList(recId);
    }
}

