/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.tag.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.modules.tag.dto.SaveExamFileTagDTO;
import io.huimu.modules.tag.dto.SaveExamItemTagDTO;
import io.huimu.modules.tag.dto.SavePatientTagDTO;
import io.huimu.modules.tag.param.DeleteTagRelationParam;
import io.huimu.modules.tag.param.GetExamFilesTagParam;
import io.huimu.modules.tag.param.GetExamItemTagParam;
import io.huimu.modules.tag.param.GetPatientTagParam;
import io.huimu.modules.tag.service.TagRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tag/relation"})
@Api(tags={"\u591a\u6a21\u6001\u6d4f\u89c8\u5668\u6807\u7b7e\u5173\u8054\u5173\u7cfb"})
public class TagRelationController {
    @Autowired
    private TagRelationService tagRelationService;

    @PostMapping(value={"savePatientTag"})
    @ApiOperation(value="\u7ed9\u60a3\u8005\u6253\u6807\u7b7e")
    @LogOperation(value="\u7ed9\u60a3\u8005\u6253\u6807\u7b7e", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=1)
    @DecryptAndVerify(decryptedClass=SavePatientTagDTO.class)
    public Result savePatientTag(@RequestBody EncryptedReq<SavePatientTagDTO> req) {
        SavePatientTagDTO dto = (SavePatientTagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class});
        this.tagRelationService.savePatientTag(dto);
        return new Result();
    }

    @PostMapping(value={"getPatientTagList"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u6807\u7b7e\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetPatientTagParam.class)
    public Result getPatientTagList(@RequestBody EncryptedReq<GetPatientTagParam> req) {
        GetPatientTagParam param = (GetPatientTagParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List resList = this.tagRelationService.getPatientTagList(param.getPatientId());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"deletePatientTag"})
    @ApiOperation(value="\u89e3\u9664\u60a3\u8005\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb")
    @LogOperation(value="\u89e3\u9664\u60a3\u8005\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=3)
    @DecryptAndVerify(decryptedClass=DeleteTagRelationParam.class)
    public Result deletePatientTag(@RequestBody EncryptedReq<DeleteTagRelationParam> req) {
        DeleteTagRelationParam param = (DeleteTagRelationParam)req.getData();
        this.tagRelationService.deletePatientTagById(param);
        return new Result();
    }

    @PostMapping(value={"saveExamItemTag"})
    @ApiOperation(value="\u7ed9\u68c0\u67e5\u9879\u6253\u6807\u7b7e")
    @LogOperation(value="\u7ed9\u68c0\u67e5\u9879\u6253\u6807\u7b7e", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveExamItemTagDTO.class)
    public Result saveExamItemTag(@RequestBody EncryptedReq<SaveExamItemTagDTO> req) {
        SaveExamItemTagDTO dto = (SaveExamItemTagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class});
        this.tagRelationService.saveExamItemTag(dto);
        return new Result();
    }

    @PostMapping(value={"deleteExamItemTag"})
    @ApiOperation(value="\u89e3\u9664\u68c0\u67e5\u9879\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb")
    @LogOperation(value="\u89e3\u9664\u68c0\u67e5\u9879\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=3)
    @DecryptAndVerify(decryptedClass=DeleteTagRelationParam.class)
    public Result deleteExamItemTag(@RequestBody EncryptedReq<DeleteTagRelationParam> req) {
        DeleteTagRelationParam param = (DeleteTagRelationParam)req.getData();
        this.tagRelationService.deleteExamItemTag(param);
        return new Result();
    }

    @PostMapping(value={"getExamItemTagList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u6807\u7b7e\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetExamItemTagParam.class)
    public Result getExamItemTagList(@RequestBody EncryptedReq<GetExamItemTagParam> req) {
        GetExamItemTagParam param = (GetExamItemTagParam)req.getData();
        List resList = this.tagRelationService.getExamItemTagList(param.getRisNo(), param.getExamNo());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"saveExamFilesTag"})
    @ApiOperation(value="\u7ed9\u68c0\u67e5\u6587\u4ef6\u6253\u6807\u7b7e")
    @LogOperation(value="\u7ed9\u68c0\u67e5\u6587\u4ef6\u6253\u6807\u7b7e", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveExamFileTagDTO.class)
    public Result saveExamFilesTag(@RequestBody EncryptedReq<SaveExamFileTagDTO> req) {
        SaveExamFileTagDTO dto = (SaveExamFileTagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class});
        this.tagRelationService.saveExamFilesTag(dto);
        return new Result();
    }

    @PostMapping(value={"deleteExamFilesTag"})
    @ApiOperation(value="\u89e3\u9664\u68c0\u67e5\u6587\u4ef6\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb")
    @LogOperation(value="\u89e3\u9664\u68c0\u67e5\u6587\u4ef6\u4e0e\u6807\u7b7e\u7684\u5173\u7cfb", module="\u6807\u7b7e\u5173\u8054\u5173\u7cfb", operationType=3)
    @DecryptAndVerify(decryptedClass=DeleteTagRelationParam.class)
    public Result deleteExamFilesTag(@RequestBody EncryptedReq<DeleteTagRelationParam> req) {
        DeleteTagRelationParam param = (DeleteTagRelationParam)req.getData();
        this.tagRelationService.deleteExamFilesTag(param.getId());
        return new Result();
    }

    @PostMapping(value={"getExamFilesTagList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u6587\u4ef6\u6807\u7b7e\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetExamFilesTagParam.class)
    public Result getExamFilesTagList(@RequestBody EncryptedReq<GetExamFilesTagParam> req) {
        GetExamFilesTagParam param = (GetExamFilesTagParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        List resList = this.tagRelationService.getExamFilesTagList(param.getRecId());
        return new Result().ok(req.getEncode(), (Object)resList);
    }
}

