/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.tag.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.vo.DictTagVO;
import io.huimu.modules.tag.dto.DictTagDTO;
import io.huimu.modules.tag.service.DictTagService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tag"})
@Api(tags={"\u6807\u7b7e\u7ba1\u7406"})
public class DictTagController {
    @Autowired
    private DictTagService dictTagService;

    @PostMapping(value={"saveTag"})
    @ApiOperation(value="\u65b0\u589e\u6807\u7b7e")
    @LogOperation(value="\u65b0\u589e\u6807\u7b7e", module="\u6807\u7b7e\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=DictTagDTO.class)
    public Result saveTag(@RequestBody EncryptedReq<DictTagDTO> req) {
        DictTagDTO dictTagDTO = (DictTagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dictTagDTO, (Class[])new Class[]{DefaultGroup.class});
        this.dictTagService.saveTag(dictTagDTO);
        return new Result();
    }

    @PostMapping(value={"updateTag"})
    @ApiOperation(value="\u4fee\u6539\u6807\u7b7e")
    @LogOperation(value="\u4fee\u6539\u6807\u7b7e", module="\u6807\u7b7e\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=DictTagDTO.class)
    public Result updateTag(@RequestBody EncryptedReq<DictTagDTO> req) {
        DictTagDTO dictTagDTO = (DictTagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dictTagDTO, (Class[])new Class[]{DefaultGroup.class, UpdateGroup.class});
        this.dictTagService.updateTag(dictTagDTO);
        return new Result();
    }

    @PostMapping(value={"tree"})
    @ApiOperation(value="\u6811\u5f62\u6570\u636e")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<List<DictTagVO>> tree(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.dictTagService.getTreeList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"deleteTag"})
    @ApiOperation(value="\u5220\u9664\u6807\u7b7e")
    @LogOperation(value="\u5220\u9664\u6807\u7b7e", module="\u6807\u7b7e\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteTag(@RequestBody EncryptedReq<IdParam> req) {
        IdParam idParam = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)idParam, (Class[])new Class[0]);
        this.dictTagService.deleteTag(idParam.getId());
        return new Result();
    }
}

