/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.sys.dao.SysUserDeptDataScopeDao;
import io.huimu.modules.sys.entity.SysDeptEntity;
import io.huimu.modules.sys.entity.SysUserDeptDataScopeEntity;
import io.huimu.modules.sys.service.SysDeptService;
import io.huimu.modules.sys.service.SysUserDeptDataScopeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserDeptDataScopeServiceImpl
extends BaseServiceImpl<SysUserDeptDataScopeDao, SysUserDeptDataScopeEntity>
implements SysUserDeptDataScopeService {
    @Autowired
    private SysDeptService sysDeptService;

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String userId, List<String> deptIds) {
        ((SysUserDeptDataScopeDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
        if (CollUtil.isEmpty(deptIds)) {
            return;
        }
        List deptEntityList = this.sysDeptService.getListByDeptIds(deptIds);
        if (CollUtil.isNotEmpty((Collection)deptEntityList)) {
            ArrayList<SysUserDeptDataScopeEntity> insertList = new ArrayList<SysUserDeptDataScopeEntity>();
            for (SysDeptEntity deptEntity : deptEntityList) {
                SysUserDeptDataScopeEntity entity = new SysUserDeptDataScopeEntity();
                entity.setUserId(userId);
                entity.setDeptCode(deptEntity.getDeptCode());
                entity.setOrgCode(deptEntity.getOrgCode());
                entity.setDeptId(deptEntity.getId());
                insertList.add(entity);
            }
            if (CollUtil.isNotEmpty(insertList)) {
                this.insertBatch(insertList, 20);
            }
        }
    }

    public List<String> getDeptDataScope(String orgCode, String userId) {
        List deptIds = ((SysUserDeptDataScopeDao)this.baseDao).getDeptDataScope(orgCode, userId);
        return deptIds;
    }

    public void deleteByDeptId(String deptId) {
        ((SysUserDeptDataScopeDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"DEPT_ID", (Object)deptId));
    }

    public List<String> getDeptCodeDataScope(String orgCode, String userId) {
        return ((SysUserDeptDataScopeDao)this.baseDao).getDeptCodeDataScope(orgCode, userId);
    }

    public List<String> getDeptDataScopeName(String orgCode, String userId) {
        return ((SysUserDeptDataScopeDao)this.baseDao).getDeptCodeDataScopeName(orgCode, userId);
    }
}

