/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.sys.dao.SysRoleUserDao;
import io.huimu.modules.sys.entity.SysRoleUserEntity;
import io.huimu.modules.sys.service.SysRoleUserService;
import io.huimu.modules.sys.vo.SysRoleVO;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysRoleUserServiceImpl
extends BaseServiceImpl<SysRoleUserDao, SysRoleUserEntity>
implements SysRoleUserService {
    public void saveOrUpdate(String userId, List<String> roleIdList, String defaultRoleId) {
        this.deleteByUserIds(new String[]{userId});
        if (CollUtil.isEmpty(roleIdList)) {
            return;
        }
        for (String roleId : roleIdList) {
            SysRoleUserEntity sysRoleUserEntity = new SysRoleUserEntity();
            sysRoleUserEntity.setUserId(userId);
            sysRoleUserEntity.setRoleId(roleId);
            if (StringUtils.isNotBlank((CharSequence)defaultRoleId) && defaultRoleId.equals(roleId)) {
                sysRoleUserEntity.setIsDefault(Integer.valueOf(1));
            }
            this.insert((Object)sysRoleUserEntity);
        }
    }

    public void deleteByRoleIds(String[] roleIds) {
        ((SysRoleUserDao)this.baseDao).deleteByRoleIds(roleIds);
    }

    public void deleteByUserIds(String[] userIds) {
        ((SysRoleUserDao)this.baseDao).deleteByUserIds(userIds);
    }

    public List<String> getRoleIdList(String userId) {
        return ((SysRoleUserDao)this.baseDao).getRoleIdList(userId);
    }

    public List<String> getRoleIdListByUserIdAndOrgCode(String userId, String orgCode) {
        return ((SysRoleUserDao)this.baseDao).getRoleIdListByUserIdAndOrgCode(userId, orgCode);
    }

    public List<SysRoleVO> getAllRoleList(Map<String, Object> param) {
        List resList = ((SysRoleUserDao)this.baseDao).getAllRoleList(param);
        return resList;
    }

    public void saveOrUpdateDefaultRole(String userId, String roleId) {
        SysRoleVO roleVO = ((SysRoleUserDao)this.baseDao).getUserRoleInfo(userId, roleId);
        if (null == roleVO) {
            throw new RenException("\u8bbe\u7f6e\u7684\u89d2\u8272\u4e0d\u5728\u6388\u6743\u4e2d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (roleVO.getIsDefault() == 1) {
            throw new RenException("\u5f53\u524d\u89d2\u8272\u662f\u4e34\u65f6\u89d2\u8272\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u89d2\u8272");
        }
        SysRoleUserEntity entity = new SysRoleUserEntity();
        entity.setIsDefault(Integer.valueOf(0));
        ((SysRoleUserDao)this.baseDao).update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId));
        entity.setIsDefault(Integer.valueOf(1));
        ((SysRoleUserDao)this.baseDao).update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)userId)).eq((Object)"ROLE_ID", (Object)roleId));
    }

    public String getDefaultRoleId(String userId, String orgCode) {
        return ((SysRoleUserDao)this.baseDao).getDefaultRoleId(userId, orgCode);
    }
}

