/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dao.SysRoleUserAuthorityDao;
import io.huimu.modules.sys.dao.SysRoleUserDao;
import io.huimu.modules.sys.dto.AuthorityQueryDTO;
import io.huimu.modules.sys.dto.SysAuthorityDTO;
import io.huimu.modules.sys.dto.SysRoleDTO;
import io.huimu.modules.sys.entity.SysRoleUserAuthorityEntity;
import io.huimu.modules.sys.entity.SysRoleUserEntity;
import io.huimu.modules.sys.enums.SuperAdminEnum;
import io.huimu.modules.sys.param.AuthorityRoleParam;
import io.huimu.modules.sys.service.SysRoleUserAuthorityService;
import io.huimu.modules.sys.vo.AuthorityInfoVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SysRoleUserAuthorityServiceImpl
extends BaseServiceImpl<SysRoleUserAuthorityDao, SysRoleUserAuthorityEntity>
implements SysRoleUserAuthorityService {
    @Autowired
    private SysRoleUserDao roleUserDao;

    public Result authorityUser(SysAuthorityDTO dto) {
        SysRoleUserAuthorityEntity entity = (SysRoleUserAuthorityEntity)ConvertUtils.sourceToTarget((Object)dto, SysRoleUserAuthorityEntity.class);
        entity.setFlag(Integer.valueOf(1));
        if (StringUtils.isEmpty((Object)dto.getId())) {
            this.insert((Object)entity);
        } else {
            this.updateById((Object)entity);
        }
        return new Result();
    }

    public List<SysRoleDTO> authorityRoleList(AuthorityRoleParam dto) {
        List<SysRoleDTO> sysRoleDTOS = ((SysRoleUserAuthorityDao)this.baseDao).authorityRoleList(dto.getUserId(), dto.getOrgCode());
        if (SecurityUser.getSuperAdmin().intValue() == SuperAdminEnum.YES.value()) {
            return sysRoleDTOS;
        }
        List userRoleList = this.roleUserDao.selectList((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)SecurityUser.getUserId()));
        if (CollectionUtils.isEmpty((Collection)userRoleList) || CollectionUtils.isEmpty((Collection)sysRoleDTOS)) {
            return sysRoleDTOS;
        }
        List roleIdList = userRoleList.stream().map(SysRoleUserEntity::getRoleId).collect(Collectors.toList());
        sysRoleDTOS = sysRoleDTOS.stream().filter(a -> roleIdList.contains(a.getId())).collect(Collectors.toList());
        return sysRoleDTOS;
    }

    public Result<PageData<AuthorityInfoVo>> authorityInfoPage(AuthorityQueryDTO dto, Boolean encode) {
        String queryUserId = null;
        if (SecurityUser.getSuperAdmin().intValue() == SuperAdminEnum.NO.value()) {
            queryUserId = SecurityUser.getUserId();
        }
        dto.setQueryUserId(queryUserId);
        List list = ((SysRoleUserAuthorityDao)this.baseDao).getAuthorityPage(dto);
        int count = list.size();
        list = list.stream().skip((dto.getPage() - 1L) * dto.getLimit()).limit(dto.getLimit()).collect(Collectors.toList());
        return new Result().ok(encode, (Object)new PageData(list, (long)count));
    }

    public Result cancelAuthor(String id) {
        SysRoleUserAuthorityEntity entity;
        if (SecurityUser.getSuperAdmin().intValue() == SuperAdminEnum.NO.value() && !(entity = (SysRoleUserAuthorityEntity)((SysRoleUserAuthorityDao)this.baseDao).selectById((Serializable)((Object)id))).getCreator().equals(SecurityUser.getUserId())) {
            return new Result().error("\u53ea\u6709\u6388\u6743\u4eba\u6216\u7ba1\u7406\u5458\u53ef\u53d6\u6d88\u6388\u6743");
        }
        ((SysRoleUserAuthorityDao)this.baseDao).cancelAuthor(id);
        return new Result();
    }

    public Result getAuthorityInfoById(String id, Boolean encode) {
        SysRoleUserAuthorityEntity entity = (SysRoleUserAuthorityEntity)((SysRoleUserAuthorityDao)this.baseDao).selectById((Serializable)((Object)id));
        return new Result().ok(encode, (Object)entity);
    }
}

