/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysOrgenDTO;
import io.huimu.modules.sys.entity.SysOrganEntity;
import io.huimu.modules.sys.param.OrganPageParam;
import io.huimu.modules.sys.param.OrganSearchParam;
import io.huimu.modules.sys.service.SysOrganService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/organ"})
@Api(tags={"\u7cfb\u7edf\u673a\u6784\u7ba1\u7406"})
public class SysOrganController {
    @Autowired
    private SysOrganService organService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=Map.class)
    public Result<PageData<SysOrganEntity>> page(@RequestBody EncryptedReq<OrganPageParam> req) throws IllegalAccessException {
        OrganPageParam params = (OrganPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.organService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"list"})
    @ApiOperation(value="\u673a\u6784\u4fe1\u606f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=OrganSearchParam.class)
    public Result list(@RequestBody EncryptedReq<OrganSearchParam> req) throws IllegalAccessException {
        OrganSearchParam param = (OrganSearchParam)req.getData();
        List list = this.organService.getAllList(MapUtils.object2Map((Object)param));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getOrganById"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u673a\u6784\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysOrganEntity> getOrganById(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysOrganEntity data = this.organService.getOrganById(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"getOrganByCode"})
    @ApiOperation(value="\u6839\u636ecode\u83b7\u53d6\u673a\u6784\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysOrganEntity> getOrganByCode(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        SysOrganEntity data = this.organService.getOrganByCode(dto.getId());
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"saveOrgan"})
    @ApiOperation(value="\u65b0\u589e\u673a\u6784")
    @LogOperation(value="\u65b0\u589e\u673a\u6784", module="\u673a\u6784\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SysOrgenDTO.class)
    public Result saveOrgan(@RequestBody EncryptedReq<SysOrgenDTO> req) {
        SysOrgenDTO dto = (SysOrgenDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.organService.saveOrgan(dto);
        return new Result();
    }

    @PostMapping(value={"updateOrgan"})
    @ApiOperation(value="\u4fee\u6539\u673a\u6784")
    @LogOperation(value="\u4fee\u6539\u673a\u6784", module="\u673a\u6784\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=SysOrgenDTO.class)
    public Result updateOrgan(@RequestBody EncryptedReq<SysOrgenDTO> req) {
        SysOrgenDTO dto = (SysOrgenDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.organService.updateOrgan(dto);
        return new Result();
    }

    @PostMapping(value={"deleteOrgan"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u673a\u6784", module="\u673a\u6784\u7ba1\u7406", operationType=3, logType=1)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteOrgan(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.organService.deleteOrgan(dto.getId());
        return new Result();
    }
}

