/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sys.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.DeptSearchParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.sys.dto.SysDeptDTO;
import io.huimu.modules.sys.service.SysDeptService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/dept"})
@Api(tags={"\u90e8\u95e8\u7ba1\u7406"})
public class SysDeptController {
    @Autowired
    private SysDeptService sysDeptService;

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DeptSearchParam.class)
    public Result<List<SysDeptDTO>> list(@RequestBody EncryptedReq<DeptSearchParam> req) throws IllegalAccessException {
        DeptSearchParam data = (DeptSearchParam)req.getData();
        List list = this.sysDeptService.getList(MapUtils.object2Map((Object)data));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result<SysDeptDTO> get(@RequestBody EncryptedReq<IdParam> req) {
        String id = ((IdParam)req.getData()).getId();
        SysDeptDTO data = this.sysDeptService.getInfo(id);
        return new Result().ok(req.getEncode(), (Object)data);
    }

    @PostMapping(value={"saveDept"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u4fdd\u5b58", module="\u90e8\u95e8\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SysDeptDTO.class)
    public Result saveDept(@RequestBody EncryptedReq<SysDeptDTO> req) {
        SysDeptDTO dto = (SysDeptDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.sysDeptService.saveDept(dto);
        return new Result();
    }

    @PostMapping(value={"updateDept"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539", module="\u90e8\u95e8\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=SysDeptDTO.class)
    public Result updateDept(@RequestBody EncryptedReq<SysDeptDTO> req) {
        SysDeptDTO dto = (SysDeptDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.sysDeptService.updateDept(dto);
        return new Result();
    }

    @PostMapping(value={"deleteDept"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664", module="\u90e8\u95e8\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        String id = ((IdParam)req.getData()).getId();
        this.sysDeptService.delete(id);
        return new Result();
    }
}

