/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sqwts.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.sqwts.dto.SqwtsDTO;
import io.huimu.modules.sqwts.param.SqwtsListParam;
import io.huimu.modules.sqwts.service.SqwtsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sqwts"})
@Api(tags={"\u6388\u6743\u59d4\u6258\u4e66\u56fe\u7247"})
public class SqwtsController {
    private static final Logger log = LoggerFactory.getLogger(SqwtsController.class);
    @Autowired
    private SqwtsService sqwtsService;

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u5217\u8868")
    @DecryptAndVerify(decryptedClass=SqwtsListParam.class)
    public Result<List<SqwtsDTO>> getList(@RequestBody EncryptedReq<SqwtsListParam> req) {
        SqwtsListParam dto = (SqwtsListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        List list = this.sqwtsService.getList(dto.getPatientIdNumber());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @DeleteMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664", module="\u6388\u6743\u59d4\u6258\u4e66\u56fe\u7247", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.sqwtsService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }
}

