/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.sqlexecute.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sqlexecute.dao.SqlExecuteDao;
import io.huimu.modules.sqlexecute.entity.SqlExecuteEntity;
import io.huimu.modules.sqlexecute.service.SqlExecuteService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.entity.UploadEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SqlExecuteServiceImpl
extends BaseServiceImpl<SqlExecuteDao, SqlExecuteEntity>
implements SqlExecuteService {
    private static final Logger log = LoggerFactory.getLogger(SqlExecuteServiceImpl.class);
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;
    @Autowired
    private TransactionDefinition transactionDefinition;

    public PageData<SqlExecuteEntity> page(Map<String, Object> params) {
        IPage page = ((SqlExecuteDao)this.baseDao).selectPage(this.getPage(params, "create_date", false), (Wrapper)this.getWrapper(params));
        return this.getPageData(page, SqlExecuteEntity.class);
    }

    private QueryWrapper<SqlExecuteEntity> getWrapper(Map<String, Object> params) {
        String executeStatus = (String)params.get("executeStatus");
        String executeDate = (String)params.get("executeDate");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.like(StringUtils.isNotBlank((CharSequence)executeStatus), (Object)"EXECUTE_STATUS", (Object)executeStatus);
        wrapper.like(StringUtils.isNotBlank((CharSequence)executeDate), (Object)"TO_CHAR(EXECUTE_DATE,'yyyy-MM-dd')", (Object)executeDate);
        return wrapper;
    }

    public void uploadFile(MultipartFile file) throws IOException {
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity encodeEntity = FileUtils.upload((MultipartFile)file, (String)ftpPath, (String)"sql_file");
        StringBuffer stringBuffer = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(ftpPath + "/" + encodeEntity.getFilePath())));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                stringBuffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UploadEntity decodeEntity = FileUtils.writeToFile((String)HutoolSm4Utils.decode((String)stringBuffer.toString()), (String)ftpPath, (String)"sql_file", null, (String)"txt");
        SqlExecuteEntity entity = new SqlExecuteEntity();
        entity.setCreateDate(new Date());
        entity.setUploadUserCode(SecurityUser.getEmployeeId());
        entity.setUploadUserName(SecurityUser.getUser().getRealName());
        entity.setEncodeFilePath(encodeEntity.getFilePath());
        entity.setFileName(file.getOriginalFilename());
        entity.setDecodeFilePath(decodeEntity.getFilePath());
        this.insert((Object)entity);
    }

    public void executeSqlFile(String id) {
        block23: {
            TransactionStatus transactionStatus = this.platformTransactionManager.getTransaction(this.transactionDefinition);
            SqlExecuteEntity entity = (SqlExecuteEntity)((SqlExecuteDao)this.baseDao).selectById((Serializable)((Object)id));
            if (null != entity) {
                entity.setExecuteUserCode(SecurityUser.getEmployeeId());
                entity.setExecuteUserName(SecurityUser.getUser().getRealName());
                entity.setExecuteDate(new Date());
                if (entity.getExecuteStatus() > 0) {
                    throw new RenException("\u8be5\u6587\u4ef6\u5df2\u7ecf\u6267\u884c\uff0c\u65e0\u6cd5\u518d\u6b21\u6267\u884c");
                }
                String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
                String filePath = ftpPath + "/" + entity.getDecodeFilePath();
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new RenException("\u6267\u884c\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                    String line;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        stringBuffer = stringBuffer.append(line);
                    }
                    if (StringUtils.isNotBlank((CharSequence)stringBuffer)) {
                        String[] strings = stringBuffer.toString().split(";");
                        if (null != strings && strings.length > 0) {
                            for (String sql : strings) {
                                try {
                                    if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                                    this.jdbcTemplate.execute(sql);
                                }
                                catch (Exception e) {
                                    entity.setExecuteStatus(Integer.valueOf(2));
                                    this.platformTransactionManager.rollback(transactionStatus);
                                    entity.setFailMsg("\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                                    this.updateById((Object)entity);
                                    throw new RenException("\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                                }
                            }
                            entity.setExecuteStatus(Integer.valueOf(1));
                            this.updateById((Object)entity);
                            this.platformTransactionManager.commit(transactionStatus);
                            break block23;
                        }
                        entity.setExecuteStatus(Integer.valueOf(2));
                        entity.setFailMsg("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                        this.updateById((Object)entity);
                        this.platformTransactionManager.commit(transactionStatus);
                        throw new RenException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                    }
                    entity.setExecuteStatus(Integer.valueOf(2));
                    entity.setFailMsg("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                    this.updateById((Object)entity);
                    this.platformTransactionManager.commit(transactionStatus);
                    throw new RenException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
                }
                catch (IOException e) {
                    entity.setExecuteStatus(Integer.valueOf(2));
                    entity.setFailMsg("\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u5f02\u5e38");
                    log.error(e.getMessage());
                    this.updateById((Object)entity);
                    this.platformTransactionManager.commit(transactionStatus);
                    throw new RenException("\u6587\u4ef6\u5185\u5bb9\u8bfb\u53d6\u5f02\u5e38");
                }
            }
            throw new RenException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
    }
}

