/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.security.service.impl;

import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.Result;
import io.huimu.modules.security.dao.SysUserTokenDao;
import io.huimu.modules.security.entity.SysUserTokenEntity;
import io.huimu.modules.security.oauth2.TokenGenerator;
import io.huimu.modules.security.service.SysUserTokenService;
import io.huimu.modules.sys.dto.SysRoleDTO;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.huimu.modules.sys.service.SysRoleService;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserTokenServiceImpl
extends BaseServiceImpl<SysUserTokenDao, SysUserTokenEntity>
implements SysUserTokenService {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public Result createToken(Boolean encode, SysUserDTO user, String roleId) {
        String token;
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        Date now = new Date();
        String tokenExpireTime = this.sysSystemConfService.getConfValue("100049", "720");
        Date expireTime = new Date(now.getTime() + (long)(Integer.valueOf(tokenExpireTime) * 60 * 1000));
        SysUserTokenEntity tokenEntity = ((SysUserTokenDao)this.baseDao).getByUserId(user.getId());
        if (tokenEntity == null) {
            token = TokenGenerator.generateValue();
            tokenEntity = new SysUserTokenEntity();
            tokenEntity.setUserId(user.getId());
            tokenEntity.setToken(token);
            tokenEntity.setUpdateDate(now);
            tokenEntity.setExpireDate(expireTime);
            tokenEntity.setRoleId(roleId);
            this.insert((Object)tokenEntity);
        } else {
            token = tokenEntity.getExpireDate().getTime() < System.currentTimeMillis() ? TokenGenerator.generateValue() : tokenEntity.getToken();
            tokenEntity.setToken(token);
            tokenEntity.setUpdateDate(now);
            tokenEntity.setExpireDate(expireTime);
            tokenEntity.setRoleId(roleId);
            this.updateById((Object)tokenEntity);
        }
        SysRoleDTO roleDTO = this.sysRoleService.getRoleInfoById(roleId);
        if (null != roleDTO) {
            resMap.put("deptCode", roleDTO.getDeptCode());
            resMap.put("deptName", roleDTO.getDeptName());
            resMap.put("orgCode", roleDTO.getOrgCode());
            resMap.put("orgName", roleDTO.getOrgName());
            user.setCurrentRoleId(roleId);
            user.setCurrentRoleName(roleDTO.getName());
        }
        resMap.put("token", token);
        resMap.put("expire", new Date(now.getTime() + (long)(Integer.valueOf(tokenExpireTime) * 60 * 1000)));
        resMap.put("roleId", roleId);
        resMap.put("currentUser", user);
        return new Result().ok(encode, resMap);
    }

    public Result getToken(Boolean encode, SysUserDTO user) {
        String token;
        HashMap<String, String> resMap = new HashMap<String, String>(4);
        Date now = new Date();
        String tokenExpireTime = this.sysSystemConfService.getConfValue("100049", "720");
        Date expireTime = new Date(now.getTime() + (long)(Integer.valueOf(tokenExpireTime) * 60 * 1000));
        SysUserTokenEntity tokenEntity = ((SysUserTokenDao)this.baseDao).getByUserId(user.getId());
        if (tokenEntity == null) {
            token = TokenGenerator.generateValue();
            tokenEntity = new SysUserTokenEntity();
            tokenEntity.setUserId(user.getId());
            tokenEntity.setToken(token);
            tokenEntity.setUpdateDate(now);
            tokenEntity.setExpireDate(expireTime);
            this.insert((Object)tokenEntity);
        } else {
            token = tokenEntity.getExpireDate().getTime() < System.currentTimeMillis() ? TokenGenerator.generateValue() : tokenEntity.getToken();
            tokenEntity.setToken(token);
            tokenEntity.setUpdateDate(now);
            tokenEntity.setExpireDate(expireTime);
            this.updateById((Object)tokenEntity);
        }
        resMap.put("token", token);
        resMap.put("userName", user.getRealName());
        return new Result().ok(encode, resMap);
    }

    public void logout(String userId) {
        String token = TokenGenerator.generateValue();
        ((SysUserTokenDao)this.baseDao).updateToken(userId, token);
    }
}

