/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.security.service.impl;

import io.huimu.modules.security.dao.SysUserTokenDao;
import io.huimu.modules.security.entity.SysUserTokenEntity;
import io.huimu.modules.security.service.ShiroService;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dao.SysMenuDao;
import io.huimu.modules.sys.dao.SysUserDao;
import io.huimu.modules.sys.entity.SysUserEntity;
import io.huimu.modules.sys.enums.SuperAdminEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShiroServiceImpl
implements ShiroService {
    @Autowired
    private SysMenuDao sysMenuDao;
    @Autowired
    private SysUserDao sysUserDao;
    @Autowired
    private SysUserTokenDao sysUserTokenDao;

    public Set<String> getRolePermissionsList(String roleId) {
        List permissionsList = SecurityUser.getSuperAdmin().intValue() == SuperAdminEnum.YES.value() ? this.sysMenuDao.getPermissionsList() : this.sysMenuDao.getRolePermissionsList(roleId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String permissions : permissionsList) {
            if (StringUtils.isBlank((CharSequence)permissions)) continue;
            permsSet.addAll(Arrays.asList(permissions.trim().split(",")));
        }
        return permsSet;
    }

    public SysUserTokenEntity getByToken(String token) {
        return this.sysUserTokenDao.getByToken(token);
    }

    public SysUserEntity getUser(String userId) {
        return this.sysUserDao.getByUserId(userId);
    }

    public void updateTokenExpireDate(SysUserTokenEntity entity) {
        this.sysUserTokenDao.updateById((Object)entity);
    }
}

