/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.security.oauth2;

import com.google.gson.Gson;
import io.huimu.common.utils.HttpContextUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.security.oauth2.Oauth2Token;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.springframework.web.bind.annotation.RequestMethod;

public class Oauth2Filter
extends AuthenticatingFilter {
    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        return new Oauth2Token(token);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return ((HttpServletRequest)request).getMethod().equals(RequestMethod.OPTIONS.name());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)token)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setContentType("application/json;charset=utf-8");
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
            String json = new Gson().toJson((Object)new Result().error(401));
            httpResponse.getWriter().print(json);
            return false;
        }
        return this.executeLogin(request, response);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
        try {
            Object throwable = e.getCause() == null ? e : e.getCause();
            Result r = new Result().error(401, ((Throwable)throwable).getMessage());
            String json = new Gson().toJson((Object)r);
            httpResponse.getWriter().print(json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private String getRequestToken(HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = httpRequest.getParameter("token");
        }
        return token;
    }
}

