/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.CustomizeEncryUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.common.utils.ZipUtils;
import io.huimu.modules.register.dao.ExamFilesDao;
import io.huimu.modules.register.dto.PauseUploadCjFilesDTO;
import io.huimu.modules.register.dto.PauseUploadVideoFilesDTO;
import io.huimu.modules.register.dto.SaveExamFilesDTO;
import io.huimu.modules.register.dto.UploadCjFilesDTO;
import io.huimu.modules.register.entity.ExamFilesEntity;
import io.huimu.modules.register.entity.RegisterItemEntity;
import io.huimu.modules.register.param.GetCreateDcmXmlParam;
import io.huimu.modules.register.param.GetDataExtractPdfFileParam;
import io.huimu.modules.register.param.GetDevicePatientParam;
import io.huimu.modules.register.param.GetExamFileByExamNoPage;
import io.huimu.modules.register.param.GetExamNoParam;
import io.huimu.modules.register.param.RelateDcmFilesParam;
import io.huimu.modules.register.param.RelateExamFilesParam;
import io.huimu.modules.register.param.RelieveDcmParam;
import io.huimu.modules.register.param.RelieveParam;
import io.huimu.modules.register.param.UpdateExamStatusParam;
import io.huimu.modules.register.param.UploadDcmParam;
import io.huimu.modules.register.service.ExamFilesService;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.register.vo.CreateDcmXmlDeviceVO;
import io.huimu.modules.register.vo.CreateDcmXmlModalityVO;
import io.huimu.modules.register.vo.CreateDcmXmlPatientVO;
import io.huimu.modules.register.vo.DataExtractFileVO;
import io.huimu.modules.register.vo.DcmStudyVO;
import io.huimu.modules.register.vo.ExamFilesVO;
import io.huimu.modules.register.vo.GetExamNoVO;
import io.huimu.modules.register.vo.PatientInfoVO;
import io.huimu.modules.register.vo.ReturnCreateXmlVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.entity.SysOrganEntity;
import io.huimu.modules.sys.service.SysOrganService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.dto.ContentDTO;
import io.huimu.modules.upload.entity.UploadEntity;
import io.huimu.modules.upload.service.UploadService;
import io.huimu.modules.websocket.WebSocketServer;
import io.huimu.modules.websocket.data.MessageData;
import io.huimu.modules.zeissdcm.service.ZeissDcmService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExamFilesServiceImpl
extends BaseServiceImpl<ExamFilesDao, ExamFilesEntity>
implements ExamFilesService {
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private WebSocketServer webSocketServer;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private SysOrganService sysOrganService;
    @Autowired
    private ZeissDcmService zeissDcmService;
    @Value(value="${hospitalCode}")
    private String hospitalCode;

    @Transactional(rollbackFor={Exception.class})
    public void uploadPdfExamFiles(SaveExamFilesDTO params) {
        RegisterItemEntity itemInfoVO = this.registerItemService.selectInfoByExamNo(params.getExamNo());
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity uploadEntity = FileUtils.base64ToFile((String)params.getFileBase(), (String)StringUtils.lowerCase((String)params.getFileType()), (String)ftpPath, (String)("device_pdf/" + params.getDeviceId()));
        if (null != uploadEntity) {
            ExamFilesEntity filesEntity = new ExamFilesEntity();
            filesEntity.setExamNo(params.getExamNo());
            filesEntity.setFileNo("1");
            filesEntity.setCreateTime(new Date());
            filesEntity.setFileType(StringUtils.upperCase((String)params.getFileType()));
            filesEntity.setHospitalOrgCode(params.getOrgCode());
            filesEntity.setUploadDevice(params.getDeviceId());
            filesEntity.setUploadTime(params.getFileCreateTime());
            filesEntity.setUploadUserId(SecurityUser.getEmployeeId());
            filesEntity.setUploadUserName(SecurityUser.getUser().getRealName());
            filesEntity.setFileSource("1");
            filesEntity.setRelateTime(new Date());
            if (StringUtils.isNotBlank((CharSequence)params.getFileSourcePath())) {
                filesEntity.setFileSourcePath(params.getFileSourcePath().replace("\\", "/"));
            }
            if (null != itemInfoVO && itemInfoVO.getPushFlag() == 1) {
                filesEntity.setFileStatus(Integer.valueOf(50));
            } else if (StringUtils.upperCase((String)params.getFileType()).equals("PDF")) {
                filesEntity.setFileStatus(Integer.valueOf(40));
            } else {
                filesEntity.setFileStatus(Integer.valueOf(50));
            }
            filesEntity.setFilePath(uploadEntity.getFileDirPath());
            filesEntity.setFileName(uploadEntity.getFileName());
            this.insert((Object)filesEntity);
        }
        UpdateExamStatusParam examStatusParam = new UpdateExamStatusParam();
        examStatusParam.setExamNo(params.getExamNo());
        examStatusParam.setDeptCode(params.getDeptCode());
        examStatusParam.setOrgCode(params.getOrgCode());
        examStatusParam.setUpdateStatusTime(params.getFileCreateTime());
        this.registerItemService.finishExamItem(examStatusParam);
        MessageData messageData = new MessageData();
        RegisterItemEntity data = this.registerItemService.selectInfoByExamNo(params.getExamNo());
        if (null != data) {
            data.setFilePath(uploadEntity.getFileDirPath() + "/" + uploadEntity.getFileName());
            data.setExamTime(new Date(params.getFileCreateTime().getTime()));
            data.setFileType("PDF");
        }
        messageData.setData((Object)data);
        messageData.setType(1);
        messageData.setCustomizeType(Integer.valueOf(1));
        this.webSocketServer.sendMessage(params.getDeviceId(), (Object)messageData);
    }

    @Transactional(rollbackFor={Exception.class})
    public void relieve(RelieveParam dto) {
        ((ExamFilesDao)this.baseDao).relievePdf(dto.getRecIds(), SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), new Date());
        this.registerItemService.updateHandCancelReport(dto.getExamNo());
    }

    public List<ExamFilesVO> getRelieveExamFiles(Map<String, Object> param) {
        return ((ExamFilesDao)this.baseDao).getRelieveExamFiles(param);
    }

    @Transactional(rollbackFor={Exception.class})
    public void relateExamFiles(RelateExamFilesParam dto) {
        ExamFilesEntity examFilesEntity = new ExamFilesEntity();
        examFilesEntity.setExamNo(dto.getExamNo());
        examFilesEntity.setRecId(dto.getRecId());
        examFilesEntity.setUploadUserId(SecurityUser.getEmployeeId());
        examFilesEntity.setUploadUserName(SecurityUser.getUser().getRealName());
        examFilesEntity.setRelateTime(new Date());
        ((ExamFilesDao)this.baseDao).relateExamFiles(examFilesEntity);
        UpdateExamStatusParam updateExamStatusParam = new UpdateExamStatusParam();
        updateExamStatusParam.setExamNo(dto.getExamNo());
        updateExamStatusParam.setOrgCode(dto.getOrgCode());
        updateExamStatusParam.setDeptCode(dto.getDeptCode());
        updateExamStatusParam.setUpdateStatusTime(null == dto.getFileDate() ? new Date() : dto.getFileDate());
        this.registerItemService.finishExamItem(updateExamStatusParam);
    }

    public List<ExamFilesVO> getDeviceExamFileByExamNo(String examNo) {
        return ((ExamFilesDao)this.baseDao).getDeviceExamFileByExamNo(examNo);
    }

    public PageData<List<List<ExamFilesVO>>> getExamFileByExamNo(GetExamFileByExamNoPage dto) {
        List list = ((ExamFilesDao)this.baseDao).getExamFileByExamNo(dto.getExamNo(), dto.getFileType(), dto.getFileSource(), dto.getIsAllFlag(), dto.getFormId());
        ArrayList resList = new ArrayList();
        Map<Integer, List<ExamFilesVO>> map = list.stream().collect(Collectors.groupingBy(ExamFilesVO::getSeriesId));
        for (Integer key : map.keySet()) {
            List tempList = map.get(key).stream().collect(Collectors.toList());
            tempList.sort(Comparator.comparing(ExamFilesVO::getFileNo).thenComparing(ExamFilesVO::getFileDate, Comparator.reverseOrder()));
            resList.add(tempList);
        }
        if (CollUtil.isNotEmpty(resList) && resList.size() > 1) {
            Collections.sort(resList, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (CollUtil.isEmpty(resList)) {
            return new PageData(new ArrayList(), 0L);
        }
        int page = Integer.valueOf(dto.getPage());
        int limit = Integer.valueOf(dto.getLimit());
        int total = resList.size();
        int fromIndex = (page - 1) * limit;
        int toIndex = page * limit;
        if (fromIndex > total) {
            return new PageData(new ArrayList(), (long)total);
        }
        if (toIndex > total) {
            toIndex = total;
        }
        List result = resList.subList(fromIndex, toIndex);
        return new PageData(result, (long)total);
    }

    public PatientInfoVO getDevicePatientInfo(GetDevicePatientParam dto) {
        return ((ExamFilesDao)this.baseDao).getDevicePatientInfo(dto.getPatientId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void uploadDcmExamFiles(UploadDcmParam dto) throws IOException {
        if (StringUtils.isBlank((CharSequence)dto.getExamNo())) {
            this.uploadZeiss(dto);
        } else if (null != dto.getUploadFlag() && dto.getUploadFlag() == 1) {
            this.uploadZeiss(dto);
        } else {
            System.out.println("\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\uff0c\u5f00\u59cb\u8f6c\u5b58");
            String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
            String dcmFilePath = this.sysSystemConfService.getConfValue("100038", null);
            UploadEntity uploadEntity = FileUtils.multiToFile((MultipartFile)dto.getZipFile(), (String)ftpPath, (String)("dcm_zip/" + dto.getDeviceId()));
            System.out.println("\u4e0a\u4f20\u5f71\u50cf\u6587\u4ef6\uff0c\u8f6c\u5b58\u8def\u5f84\uff1a" + uploadEntity.getFilePath());
            String modality = this.registerItemService.getModalityByExamNo(dto.getExamNo());
            String dcmPath = FileUtils.getDcmFileDirPath((String)modality, (String)dto.getDeviceId(), (String)dto.getPatientId());
            ZipUtils.unzipNoDir((String)(ftpPath + "/" + uploadEntity.getFilePath()), (String)(dcmFilePath + "/" + dcmPath));
            UpdateExamStatusParam examStatusParam = new UpdateExamStatusParam();
            examStatusParam.setExamNo(dto.getExamNo());
            examStatusParam.setDeptCode(dto.getDeptCode());
            examStatusParam.setOrgCode(dto.getOrgCode());
            examStatusParam.setUpdateStatusTime(dto.getFileCreateTime());
            this.registerItemService.finishExamItem(examStatusParam);
            RegisterItemEntity itemInfoVO = this.registerItemService.selectInfoByExamNo(dto.getExamNo());
            MessageData messageData = new MessageData();
            messageData.setData((Object)itemInfoVO);
            messageData.setType(1);
            messageData.setCustomizeType(Integer.valueOf(2));
            this.webSocketServer.sendMessage(dto.getDeviceId(), (Object)messageData);
            this.uploadZeiss(dto);
        }
    }

    public void uploadZeiss(UploadDcmParam dto) throws IOException {
        System.out.println("\u4e0a\u4f20\u8521\u53f8\u670d\u52a1\u5668\uff0c\u5f00\u59cb\u6587\u4ef6\u8f6c\u5b58");
        if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
            UploadEntity uploadEntity = FileUtils.multiToFile((MultipartFile)dto.getZipFile(), (String)ftpPath, (String)("zeiss_dcm_zip/" + dto.getDeviceId()));
            System.out.println("\u4e0a\u4f20\u8521\u53f8\u670d\u52a1\u5668\uff0c\u6587\u4ef6\u8f6c\u5b58\u5730\u5740\uff1a" + uploadEntity.getFilePath());
            this.zeissDcmService.sendZeiss(ftpPath, uploadEntity.getFilePath(), dto);
        }
    }

    public GetExamNoVO getExamNo(GetExamNoParam dto) {
        List examNos = ((ExamFilesDao)this.baseDao).getExamNos(dto.getPatientId(), dto.getExamDate(), dto.getOrgCode(), dto.getDeviceId());
        if (CollUtil.isNotEmpty((Collection)examNos)) {
            return (GetExamNoVO)examNos.get(0);
        }
        return null;
    }

    public void deleteExamFiles(Integer recId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(recId);
        ((ExamFilesDao)this.baseDao).relievePdf(list, SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), new Date());
    }

    public void pauseUploadCjFiles(PauseUploadCjFilesDTO dto) {
        ContentDTO contentDTO = new ContentDTO();
        contentDTO.setContent(dto.getContent());
        contentDTO.setPath("gather_img/" + dto.getDeviceId());
        UploadEntity uploadEntity = this.uploadService.baseToImage(contentDTO);
        if (null == uploadEntity) {
            throw new RenException("\u4e0a\u4f20\u5931\u8d25");
        }
        ExamFilesEntity entity = new ExamFilesEntity();
        entity.setExamNo(dto.getExamNo());
        entity.setUploadUserName(SecurityUser.getUser().getRealName());
        entity.setFileName(uploadEntity.getFileNewName());
        entity.setFilePath(uploadEntity.getFileDirPath());
        entity.setFileStatus(Integer.valueOf(30));
        entity.setHospitalOrgCode(dto.getOrgCode());
        entity.setFileSource("2");
        entity.setFileType("JPG");
        entity.setUploadUserId(SecurityUser.getEmployeeId());
        entity.setUploadTime(new Date());
        entity.setUploadDevice(dto.getDeviceId());
        entity.setFileNo("1");
        this.insert((Object)entity);
    }

    public void pauseUploadCjMulti(MultipartFile file, String examNo, String deviceId, String orgCode) throws IOException {
        UploadEntity uploadEntity = this.uploadService.uploadFileWithPath(file, "gather_img/" + deviceId);
        if (null == uploadEntity) {
            throw new RenException("\u4e0a\u4f20\u5931\u8d25");
        }
        ExamFilesEntity entity = new ExamFilesEntity();
        entity.setExamNo(examNo);
        entity.setUploadUserName(SecurityUser.getUser().getRealName());
        entity.setFileName(uploadEntity.getFileNewName());
        entity.setFilePath(uploadEntity.getFileDirPath());
        entity.setFileStatus(Integer.valueOf(30));
        entity.setHospitalOrgCode(orgCode);
        entity.setFileSource("2");
        entity.setFileType("JPG");
        entity.setUploadUserId(SecurityUser.getEmployeeId());
        entity.setUploadTime(new Date());
        entity.setUploadDevice(deviceId);
        entity.setFileNo("1");
        this.insert((Object)entity);
    }

    public void pauseUploadVideoFiles(PauseUploadVideoFilesDTO dto) throws IOException {
        UploadEntity uploadEntity = this.uploadService.uploadFileWithPath(dto.getFile(), "gather_video/" + dto.getDeviceId());
        if (null == uploadEntity) {
            throw new RenException("\u4e0a\u4f20\u5931\u8d25");
        }
        ExamFilesEntity entity = new ExamFilesEntity();
        entity.setExamNo(dto.getExamNo());
        entity.setUploadUserName(SecurityUser.getUser().getRealName());
        entity.setFileName(uploadEntity.getFileNewName());
        entity.setFilePath(uploadEntity.getFileDirPath());
        entity.setFileStatus(Integer.valueOf(30));
        entity.setHospitalOrgCode(dto.getOrgCode());
        entity.setFileSource("2");
        entity.setFileType("MP4");
        entity.setUploadUserId(SecurityUser.getEmployeeId());
        entity.setUploadTime(new Date());
        entity.setUploadDevice(dto.getDeviceId());
        entity.setFileNo("1");
        this.insert((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> uploadCjFiles(UploadCjFilesDTO dto) {
        for (Integer recId : dto.getFileIds()) {
            ((ExamFilesDao)this.baseDao).uploadCjFiles(recId, 40);
        }
        List list = ((ExamFilesDao)this.baseDao).selectList((Wrapper)new QueryWrapper().in((Object)"rec_id", (Collection)dto.getFileIds()));
        ArrayList<String> returnList = new ArrayList<String>();
        for (ExamFilesEntity examFilesEntity : list) {
            returnList.add(examFilesEntity.getFilePath() + "/" + examFilesEntity.getFileName());
        }
        return returnList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelUploadCjFiles(UploadCjFilesDTO dto) {
        for (Integer recId : dto.getFileIds()) {
            ((ExamFilesDao)this.baseDao).cancelUploadCjFiles(recId, 30);
        }
    }

    public void uploadSecondFiles(String orgCode, String deptCode, String filePath, String fileName, String examNo, String deviceId, String formId, Integer pushFlag) {
        if (null == pushFlag) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)examNo) && StringUtils.isNotBlank((CharSequence)filePath) && StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isNotBlank((CharSequence)formId)) {
            Integer count = ((ExamFilesDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)formId));
            if (count == 0) {
                ExamFilesEntity filesEntity = new ExamFilesEntity();
                filesEntity.setFileStatus(Integer.valueOf(50));
                filesEntity.setHospitalOrgCode(orgCode);
                filesEntity.setFilePath(filePath);
                filesEntity.setFileName(fileName);
                filesEntity.setExamNo(examNo);
                filesEntity.setFormId(formId);
                filesEntity.setFileNo("1");
                filesEntity.setUploadDevice(deviceId);
                filesEntity.setUploadTime(new Date());
                filesEntity.setUploadUserName(SecurityUser.getUser().getRealName());
                filesEntity.setUploadUserId(SecurityUser.getEmployeeId());
                filesEntity.setFileSource("3");
                filesEntity.setFileType("PDF");
                filesEntity.setCreateTime(new Date());
                filesEntity.setEditReportTime(new Date());
                filesEntity.setEditReportUserCode(SecurityUser.getEmployeeId());
                filesEntity.setEditReportUserName(SecurityUser.getUser().getRealName());
                this.insert((Object)filesEntity);
            } else {
                ExamFilesEntity filesEntity = new ExamFilesEntity();
                filesEntity.setFilePath(filePath);
                filesEntity.setFileName(fileName);
                filesEntity.setUploadDevice(deviceId);
                filesEntity.setUploadTime(new Date());
                filesEntity.setUploadUserName(SecurityUser.getUser().getRealName());
                filesEntity.setUploadUserId(SecurityUser.getEmployeeId());
                filesEntity.setFormId(formId);
                filesEntity.setEditReportTime(new Date());
                filesEntity.setEditReportUserCode(SecurityUser.getEmployeeId());
                filesEntity.setEditReportUserName(SecurityUser.getUser().getRealName());
                this.update((Object)filesEntity, (Wrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)formId));
            }
            ((ExamFilesDao)this.baseDao).callExamItemWcbg(formId, examNo, SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), deptCode, orgCode);
            if (null != pushFlag && pushFlag <= 2) {
                this.verifyReport(Integer.valueOf(2), Integer.valueOf(20), formId, "\u81ea\u52a8\u5ba1\u6838", deptCode, orgCode);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByFormId(String formId, String examNo, int existCount) {
        ((ExamFilesDao)this.baseDao).deleteByFormId(formId);
        if (existCount == 0) {
            ((ExamFilesDao)this.baseDao).callExamItemDelForm(examNo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void verifyReport(Integer isAuto, Integer verifyFlag, String formId, String verifyMsg, String deptCode, String orgCode) {
        ExamFilesEntity dbEntity = (ExamFilesEntity)((ExamFilesDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)formId));
        if (null != dbEntity) {
            String reportUserCode = SecurityUser.getEmployeeId();
            String reportUserName = SecurityUser.getUser().getRealName();
            ExamFilesEntity filesEntity = new ExamFilesEntity();
            filesEntity.setRecId(dbEntity.getRecId());
            filesEntity.setVerifyReportTime(new Date());
            filesEntity.setVerifyReportUserCode(reportUserCode);
            filesEntity.setVerifyReportUserName(reportUserName);
            filesEntity.setVerifyMsg(verifyMsg);
            ((ExamFilesDao)this.baseDao).update((Object)filesEntity, (Wrapper)new QueryWrapper().eq((Object)"REC_ID", (Object)dbEntity.getRecId()));
            ((ExamFilesDao)this.baseDao).callExamItemShbg(formId, dbEntity.getExamNo(), reportUserCode, reportUserName, deptCode, orgCode, verifyMsg, verifyFlag);
        }
    }

    public void cancelVerifyForm(String formId) {
        ExamFilesEntity dbEntity = (ExamFilesEntity)((ExamFilesDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"FORM_ID", (Object)formId));
        if (null != dbEntity) {
            ((ExamFilesDao)this.baseDao).callExamItemQxShbg(formId, dbEntity.getExamNo());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCjFiles(UploadCjFilesDTO dto) {
        ((ExamFilesDao)this.baseDao).deleteCjFiles(dto.getFileIds());
    }

    public ReturnCreateXmlVO getCreateDcmXml(GetCreateDcmXmlParam dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getLaterality())) {
            if (StringUtils.upperCase((String)dto.getLaterality()).contains("D") || dto.getLaterality().equalsIgnoreCase("R") || dto.getLaterality().equalsIgnoreCase("\u53f3")) {
                dto.setLaterality("R");
            } else if (StringUtils.upperCase((String)dto.getLaterality()).contains("S") || dto.getLaterality().equalsIgnoreCase("L") || dto.getLaterality().equalsIgnoreCase("\u5de6")) {
                dto.setLaterality("L");
            } else if (StringUtils.upperCase((String)dto.getLaterality()).equalsIgnoreCase("B") || dto.getLaterality().equalsIgnoreCase("\u53cc")) {
                dto.setLaterality("B");
            } else {
                dto.setLaterality("");
            }
        } else {
            dto.setLaterality("");
        }
        if (dto.getConvertType() == 2000) {
            return this.createPdf2DcmXml(dto);
        }
        if (dto.getConvertType() == 1000) {
            return this.createJpg2DcmXml(dto);
        }
        if (dto.getConvertType() == 3020) {
            return this.createYy2DcmXml(dto);
        }
        return null;
    }

    private ReturnCreateXmlVO createPdf2DcmXml(GetCreateDcmXmlParam dto) {
        SysOrganEntity organEntity;
        CreateDcmXmlPatientVO patientVO;
        Random random = new Random();
        int number = random.nextInt(900) + 100;
        String StudyID = DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + number;
        Long currentTimestamp = new Date().getTime();
        String sopInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47923.400001";
        String studyInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47922.21";
        String seriesInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47923.31";
        CreateDcmXmlModalityVO modalityVO = new CreateDcmXmlModalityVO();
        if (StringUtils.isNotBlank((CharSequence)dto.getExamNo())) {
            modalityVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlParam(dto.getExamNo());
        }
        if (null == modalityVO) {
            modalityVO = new CreateDcmXmlModalityVO();
        }
        if (null == (patientVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlPatientParam(dto.getPatientId(), dto.getOrgCode()))) {
            patientVO = new CreateDcmXmlPatientVO();
        }
        if (null == (organEntity = this.sysOrganService.getOrganByCode(dto.getOrgCode()))) {
            organEntity = new SysOrganEntity();
        }
        if (StringUtils.isBlank((CharSequence)patientVO.getPatientSex())) {
            patientVO.setPatientSex("O");
        } else if (patientVO.getPatientSex().contains("\u7537") || patientVO.getPatientSex().equalsIgnoreCase("M")) {
            patientVO.setPatientSex("M");
        } else if (patientVO.getPatientSex().contains("\u5973") || patientVO.getPatientSex().equalsIgnoreCase("F")) {
            patientVO.setPatientSex("F");
        } else {
            patientVO.setPatientSex("O");
        }
        CreateDcmXmlDeviceVO deviceVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlDevice(dto.getDeviceId());
        if (null == deviceVO) {
            deviceVO = new CreateDcmXmlDeviceVO();
        }
        ReturnCreateXmlVO vo = new ReturnCreateXmlVO();
        vo.setConvertType(dto.getConvertType());
        vo.setP1("<XML><ODSP><EXEPIN DICOMType=\"2000\"><Patient PatientID=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientId()) ? patientVO.getPatientId() : "") + "\"" + " PatientName=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientName()) ? patientVO.getPatientName() : "") + "\"" + " PatientSex=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientSex()) ? patientVO.getPatientSex() : "") + "\"" + " PatientDOB=\"" + (null != patientVO.getPatientBirthday() ? DateUtils.format((Date)patientVO.getPatientBirthday(), (String)"yyyyMMdd") : "") + "\"" + " PatientIssuerID=\"\">" + "</Patient>" + "<Study" + " AccessionNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getExamNo()) ? dto.getExamNo() : "") + "\"" + " StudyDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " StudyTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " StudyID=\"" + StudyID + "\"" + " SOPClassUID=\"1.2.840.10008.5.1.4.1.1.104.1\"" + " StudyInstanceUID=\"" + studyInstanceUid + "\"" + " StudyDescription=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getExamTypeNameEn()) ? deviceVO.getExamTypeNameEn() : "") + "\"" + " UploadDevice=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDeviceId()) ? dto.getDeviceId() : "") + "\"" + " HospitalOrgCode=\"" + (StringUtils.isNotBlank((CharSequence)dto.getOrgCode()) ? dto.getOrgCode() : "") + "\"" + " ReferringPhysicianCode=\"" + SecurityUser.getEmployeeId() + "\"" + " ReferringPhysicianName=\"" + SecurityUser.getUser().getRealName() + "\">" + "</Study>" + "<Series" + " CreatorVersionUID=\"#NULL#\"" + " SoftwareVersions=\"#NULL#\"" + " SeriesDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " SeriesTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " SeriesNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getIndexData()) ? dto.getIndexData() : "1") + "\"" + " Manufacturer=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getBrand()) ? deviceVO.getBrand() : "") + "\"" + " Modality=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamModality()) ? modalityVO.getExamModality() : "") + "\"" + " ModelName=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getModel()) ? deviceVO.getModel() : "") + "\"" + " InstitutionName=\"" + (StringUtils.isNotBlank((CharSequence)organEntity.getOrgName()) ? organEntity.getOrgName() : "") + "\"" + " SeriesDescription=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamineItem()) ? modalityVO.getExamineItem() : "") + "\"" + " SeriesInstanceUID=\"" + seriesInstanceUid + "\">" + "</Series>" + "<Image" + " BurnedInAnnotation = \"#NULL#\"" + " ImageDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " ImageTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " ImageLaterality = \"#NULL#\"" + " ImageType=\"#NULL#\"" + " InstanceNumber=\"1\"" + " Laterality=\"" + (StringUtils.isNotBlank((CharSequence)dto.getLaterality()) ? dto.getLaterality() : "B") + "\"" + " SOPInstanceUID=\"" + sopInstanceUid + "\"" + " PdfDocTitle=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamineItem()) ? modalityVO.getExamineItem() : "\u68c0\u67e5") + "\">" + "</Image>" + "</EXEPIN>" + "</ODSP>" + "</XML>");
        vo.setP2("<XML><ODSP><EXESIN ReportFile=\"" + (StringUtils.isNotBlank((CharSequence)dto.getFileNameIn()) ? dto.getFileNameIn() : "") + "\"" + " OutputFile=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDcmFileNameOut()) ? dto.getDcmFileNameOut() : "") + "\"" + " TaskID=\"" + vo.getP1().length() + "\"" + " Type=\"0\"/>" + "</ODSP>" + "</XML>");
        System.out.println("P1\uff1a" + vo.getP1());
        System.out.println("P2\uff1a" + vo.getP2());
        vo.setP1(CustomizeEncryUtils.encrypXML((String)vo.getP1()));
        vo.setP2(CustomizeEncryUtils.encrypXML((String)vo.getP2()));
        return vo;
    }

    private ReturnCreateXmlVO createJpg2DcmXml(GetCreateDcmXmlParam dto) {
        SysOrganEntity organEntity;
        CreateDcmXmlPatientVO patientVO;
        Random random = new Random();
        int number = random.nextInt(900) + 100;
        String StudyID = DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + number;
        Long currentTimestamp = new Date().getTime();
        String sopInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47914.400001";
        String studyInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47912.21";
        String seriesInstanceUid = "1.2.276.0.75.2.6.50." + DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + "." + currentTimestamp + "." + (random.nextInt(900) + 100) + ".47913.31";
        CreateDcmXmlModalityVO modalityVO = new CreateDcmXmlModalityVO();
        if (StringUtils.isNotBlank((CharSequence)dto.getExamNo())) {
            modalityVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlParam(dto.getExamNo());
        }
        if (null == modalityVO) {
            modalityVO = new CreateDcmXmlModalityVO();
        }
        if (null == (patientVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlPatientParam(dto.getPatientId(), dto.getOrgCode()))) {
            patientVO = new CreateDcmXmlPatientVO();
        }
        if (null == (organEntity = this.sysOrganService.getOrganByCode(dto.getOrgCode()))) {
            organEntity = new SysOrganEntity();
        }
        if (StringUtils.isBlank((CharSequence)patientVO.getPatientSex())) {
            patientVO.setPatientSex("O");
        } else if (patientVO.getPatientSex().contains("\u7537") || patientVO.getPatientSex().equalsIgnoreCase("M")) {
            patientVO.setPatientSex("M");
        } else if (patientVO.getPatientSex().contains("\u5973") || patientVO.getPatientSex().equalsIgnoreCase("F")) {
            patientVO.setPatientSex("F");
        } else {
            patientVO.setPatientSex("O");
        }
        CreateDcmXmlDeviceVO deviceVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlDevice(dto.getDeviceId());
        if (null == deviceVO) {
            deviceVO = new CreateDcmXmlDeviceVO();
        }
        ReturnCreateXmlVO vo = new ReturnCreateXmlVO();
        vo.setConvertType(dto.getConvertType());
        vo.setP1("<XML><ODSP><EXEPIN DICOMType=\"1000\"><Patient PatientID=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientId()) ? patientVO.getPatientId() : "") + "\"" + " PatientName=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientName()) ? patientVO.getPatientName() : "") + "\"" + " PatientSex=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientSex()) ? patientVO.getPatientSex() : "") + "\"" + " PatientDOB=\"" + (null != patientVO.getPatientBirthday() ? DateUtils.format((Date)patientVO.getPatientBirthday(), (String)"yyyyMMdd") : "") + "\"" + " PatientIssuerID=\"\">" + "</Patient>" + "<Study" + " AccessionNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getExamNo()) ? dto.getExamNo() : "") + "\"" + " StudyDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " StudyTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " StudyID=\"" + StudyID + "\"" + " SOPClassUID=\"1.2.840.10008.5.1.4.1.1.7\"" + " StudyInstanceUID=\"" + studyInstanceUid + "\"" + " StudyDescription=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getExamTypeNameEn()) ? deviceVO.getExamTypeNameEn() : "") + "\"" + " UploadDevice=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDeviceId()) ? dto.getDeviceId() : "") + "\"" + " HospitalOrgCode=\"" + (StringUtils.isNotBlank((CharSequence)dto.getOrgCode()) ? dto.getOrgCode() : "") + "\"" + " ReferringPhysicianCode=\"" + SecurityUser.getEmployeeId() + "\"" + " ReferringPhysicianName=\"" + SecurityUser.getUser().getRealName() + "\">" + "</Study>" + "<Series" + " CreatorVersionUID=\"#NULL#\"" + " SoftwareVersions=\"#NULL#\"" + " SeriesDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " SeriesTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " SeriesNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getIndexData()) ? dto.getIndexData() : "1") + "\"" + " Manufacturer=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getBrand()) ? deviceVO.getBrand() : "") + "\"" + " Modality=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamModality()) ? modalityVO.getExamModality() : "") + "\"" + " ModelName=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getModel()) ? deviceVO.getModel() : "") + "\"" + " InstitutionName=\"" + (StringUtils.isNotBlank((CharSequence)organEntity.getOrgName()) ? organEntity.getOrgName() : "") + "\"" + " SeriesDescription=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamineItem()) ? modalityVO.getExamineItem() : "") + "\"" + " SeriesInstanceUID=\"" + seriesInstanceUid + "\">" + "</Series>" + "<Image" + " BurnedInAnnotation = \"#NULL#\"" + " ImageDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " ImageTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " ImageLaterality = \"#NULL#\"" + " ImageType=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getStandardJcEnName()) ? "DERIVED\\SECONDARY\\OPHTHALMIC\\" + modalityVO.getStandardJcEnName() : "DERIVED\\SECONDARY\\OPHTHALMIC\\") + "\"" + " InstanceNumber=\"1\"" + " Laterality=\"" + (StringUtils.isNotBlank((CharSequence)dto.getLaterality()) ? dto.getLaterality() : "") + "\"" + " SOPInstanceUID=\"" + sopInstanceUid + "\">" + "</Image>" + "</EXEPIN>" + "</ODSP>" + "</XML>");
        vo.setP2("<XML><ODSP><EXESIN ESFileName=\"" + (StringUtils.isNotBlank((CharSequence)dto.getFileNameIn()) ? dto.getFileNameIn() : "") + "\"" + " OutputFile=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDcmFileNameOut()) ? dto.getDcmFileNameOut() : "") + "\"" + " TaskID=\"" + vo.getP1().length() + "\"" + " Type=\"0\"/>" + "</ODSP>" + "</XML>");
        System.out.println("P1\uff1a" + vo.getP1());
        System.out.println("P2\uff1a" + vo.getP2());
        vo.setP1(CustomizeEncryUtils.encrypXML((String)vo.getP1()));
        vo.setP2(CustomizeEncryUtils.encrypXML((String)vo.getP2()));
        return vo;
    }

    private ReturnCreateXmlVO createYy2DcmXml(GetCreateDcmXmlParam dto) {
        SysOrganEntity organEntity;
        CreateDcmXmlPatientVO patientVO;
        Random random = new Random();
        int number = random.nextInt(900) + 100;
        String StudyID = DateUtils.format((Date)new Date(), (String)"yyyyMMdd") + number;
        CreateDcmXmlModalityVO modalityVO = new CreateDcmXmlModalityVO();
        if (StringUtils.isNotBlank((CharSequence)dto.getExamNo())) {
            modalityVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlParam(dto.getExamNo());
        }
        if (null == modalityVO) {
            modalityVO = new CreateDcmXmlModalityVO();
        }
        if (null == (patientVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlPatientParam(dto.getPatientId(), dto.getOrgCode()))) {
            patientVO = new CreateDcmXmlPatientVO();
        }
        if (null == (organEntity = this.sysOrganService.getOrganByCode(dto.getOrgCode()))) {
            organEntity = new SysOrganEntity();
        }
        if (StringUtils.isBlank((CharSequence)patientVO.getPatientSex())) {
            patientVO.setPatientSex("O");
        } else if (patientVO.getPatientSex().contains("\u7537") || patientVO.getPatientSex().equalsIgnoreCase("M")) {
            patientVO.setPatientSex("M");
        } else if (patientVO.getPatientSex().contains("\u5973") || patientVO.getPatientSex().equalsIgnoreCase("F")) {
            patientVO.setPatientSex("F");
        } else {
            patientVO.setPatientSex("O");
        }
        CreateDcmXmlDeviceVO deviceVO = ((ExamFilesDao)this.baseDao).getCreateDcmXmlDevice(dto.getDeviceId());
        if (null == deviceVO) {
            deviceVO = new CreateDcmXmlDeviceVO();
        }
        ReturnCreateXmlVO vo = new ReturnCreateXmlVO();
        vo.setConvertType(dto.getConvertType());
        vo.setP1("<XML><ODSP><EXEPIN DICOMType=\"3020\"><Patient PatientID=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientId()) ? patientVO.getPatientId() : "") + "\"" + " PatientName=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientName()) ? patientVO.getPatientName() : "") + "\"" + " PatientSex=\"" + (StringUtils.isNotBlank((CharSequence)patientVO.getPatientSex()) ? patientVO.getPatientSex() : "") + "\"" + " PatientDOB=\"" + (null != patientVO.getPatientBirthday() ? DateUtils.format((Date)patientVO.getPatientBirthday(), (String)"yyyyMMdd") : "") + "\"" + " PatientIssuerID=\"\">" + "</Patient>" + "<Study" + " AccessionNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getExamNo()) ? dto.getExamNo() : "") + "\"" + " StudyDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " StudyTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " StudyID=\"" + StudyID + "\"" + " SOPClassUID=\"1.2.840.10008.5.1.4.1.1.7\"" + " StudyInstanceUID=\"\"" + " StudyDescription=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getExamTypeNameEn()) ? deviceVO.getExamTypeNameEn() : "") + "\"" + " UploadDevice=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDeviceId()) ? dto.getDeviceId() : "") + "\"" + " HospitalOrgCode=\"" + (StringUtils.isNotBlank((CharSequence)dto.getOrgCode()) ? dto.getOrgCode() : "") + "\"" + " ReferringPhysicianCode=\"" + SecurityUser.getEmployeeId() + "\"" + " ReferringPhysicianName=\"" + SecurityUser.getUser().getRealName() + "\">" + "</Study>" + "<Series" + " CreatorVersionUID=\"1.2.276.0.75.2.6.50.1.6.1.0\"" + " SoftwareVersions=\"#NULL#\"" + " SeriesDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " SeriesTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " SeriesNumber=\"" + (StringUtils.isNotBlank((CharSequence)dto.getIndexData()) ? dto.getIndexData() : "1") + "\"" + " Manufacturer=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getBrand()) ? deviceVO.getBrand() : "") + "\"" + " Modality=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamModality()) ? modalityVO.getExamModality() : "") + "\"" + " ModelName=\"" + (StringUtils.isNotBlank((CharSequence)deviceVO.getModel()) ? deviceVO.getModel() : "") + "\"" + " InstitutionName=\"" + (StringUtils.isNotBlank((CharSequence)organEntity.getOrgName()) ? organEntity.getOrgName() : "") + "\"" + " SeriesDescription=\"" + (StringUtils.isNotBlank((CharSequence)modalityVO.getExamineItem()) ? modalityVO.getExamineItem() : "") + "\"" + " SeriesInstanceUID=\"\">" + "</Series>" + "<Image" + " BurnedInAnnotation = \"#NULL#\"" + " ImageDate=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"yyyyMMdd") : "") + "\"" + " ImageTime=\"" + (null != dto.getExamTime() ? DateUtils.format((Date)dto.getExamTime(), (String)"HHmmss") : "") + "\"" + " ImageLaterality = \"" + (StringUtils.isNotBlank((CharSequence)dto.getLaterality()) ? dto.getLaterality() : "B") + "\"" + " ImageType=\"#NULL#\"" + " InstanceNumber=\"1\"" + " Laterality=\"#NULL#\"" + " SOPInstanceUID=\"\">" + "</Image>" + "<ExamData>" + "<IOPL Pressure=\"" + (StringUtils.isNotBlank((CharSequence)dto.getIopLPva()) ? dto.getIopLPva() : "") + "\"/>" + "<IOPR Pressure=\"" + (StringUtils.isNotBlank((CharSequence)dto.getIopRPva()) ? dto.getIopRPva() : "") + "\"/>" + "</ExamData>" + "</EXEPIN>" + "</ODSP>" + "</XML>");
        vo.setP2("<XML><ODSP><EXESIN OutputFile=\"" + (StringUtils.isNotBlank((CharSequence)dto.getDcmFileNameOut()) ? dto.getDcmFileNameOut() : "") + "\"" + " TaskID=\"" + vo.getP1().length() + "\"" + " Type=\"0\"/>" + "</ODSP>" + "</XML>");
        System.out.println("P1\uff1a" + vo.getP1());
        System.out.println("P2\uff1a" + vo.getP2());
        vo.setP1(CustomizeEncryUtils.encrypXML((String)vo.getP1()));
        vo.setP2(CustomizeEncryUtils.encrypXML((String)vo.getP2()));
        return vo;
    }

    public List<DataExtractFileVO> getDataExtractPdfFile(GetDataExtractPdfFileParam dto) {
        return ((ExamFilesDao)this.baseDao).getDataExtractPdfFile(dto);
    }

    public List<List<DataExtractFileVO>> getDataExtractDcmFile(GetDataExtractPdfFileParam dto) {
        List fileList = ((ExamFilesDao)this.baseDao).getDataExtractDcmFile(dto.getExamNo());
        ArrayList<List<DataExtractFileVO>> resList = new ArrayList<List<DataExtractFileVO>>();
        Map<String, List<DataExtractFileVO>> map = fileList.stream().collect(Collectors.groupingBy(DataExtractFileVO::getId));
        for (String key : map.keySet()) {
            List list = map.get(key).stream().collect(Collectors.toList());
            list.sort(Comparator.comparing(DataExtractFileVO::getFileSort).thenComparing(DataExtractFileVO::getUploadTime, Comparator.reverseOrder()));
            resList.add(list);
        }
        return resList;
    }

    public List<DcmStudyVO> getDeviceDcmExamFileByExamNo(String examNo) {
        List studyList = ((ExamFilesDao)this.baseDao).getStudyList(examNo);
        if (CollUtil.isNotEmpty((Collection)studyList)) {
            for (DcmStudyVO studyVO : studyList) {
                studyVO.setSeriesList(((ExamFilesDao)this.baseDao).getSeriesImage(studyVO.getStudyInstanceUid()));
            }
        }
        return studyList;
    }

    public List<DcmStudyVO> getRelieveDcmExamFileByExamNo(Map<String, Object> param) {
        List studyList = ((ExamFilesDao)this.baseDao).getRelieveStudyList(param);
        if (CollUtil.isNotEmpty((Collection)studyList)) {
            for (DcmStudyVO studyVO : studyList) {
                studyVO.setSeriesList(((ExamFilesDao)this.baseDao).getSeriesImage(studyVO.getStudyInstanceUid()));
            }
        }
        return studyList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void relieveDcm(RelieveDcmParam dto) {
        ((ExamFilesDao)this.baseDao).relieveDcm(dto.getRecIds(), SecurityUser.getEmployeeId(), SecurityUser.getUser().getRealName(), new Date());
        this.registerItemService.updateHandCancelReport(dto.getExamNo());
    }

    public void relateDcmFiles(RelateDcmFilesParam dto) {
        dto.setRelateUserId(SecurityUser.getEmployeeId());
        dto.setRelateUserName(SecurityUser.getUser().getRealName());
        dto.setRelateTime(new Date());
        ((ExamFilesDao)this.baseDao).relateDcmFiles(dto);
        UpdateExamStatusParam updateExamStatusParam = new UpdateExamStatusParam();
        updateExamStatusParam.setExamNo(dto.getExamNo());
        updateExamStatusParam.setOrgCode(dto.getOrgCode());
        updateExamStatusParam.setDeptCode(dto.getDeptCode());
        updateExamStatusParam.setUpdateStatusTime(null == dto.getFileDate() ? new Date() : dto.getFileDate());
        this.registerItemService.finishExamItem(updateExamStatusParam);
    }
}

