/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.ExcelUtils;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.bdform.dto.BdTemplateDTO;
import io.huimu.modules.register.dto.ScProjectDTO;
import io.huimu.modules.register.dto.SwitchProjectZsFlagDTO;
import io.huimu.modules.register.excel.ScProjectExcel;
import io.huimu.modules.register.param.ChangeProjectEnabledParam;
import io.huimu.modules.register.param.DelProjectParam;
import io.huimu.modules.register.param.GetCheckProjectSearchParam;
import io.huimu.modules.register.param.GetInfoByExamNoParam;
import io.huimu.modules.register.param.GetKnowParam;
import io.huimu.modules.register.param.ScProjectPageParam;
import io.huimu.modules.register.param.ScProjectSearchParam;
import io.huimu.modules.register.service.ScProjectService;
import io.huimu.modules.register.vo.ScProjectTreeDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sc/project"})
@Api(tags={"\u68c0\u67e5\u9879\u76ee\u7ba1\u7406"})
public class ScProjectController {
    @Autowired
    private ScProjectService scProjectService;

    @PostMapping(value={"getPage"})
    @ApiOperation(value="\u68c0\u67e5\u9879\u76ee\u5206\u9875")
    @DecryptAndVerify(decryptedClass=ScProjectPageParam.class)
    public Result<PageData<ScProjectDTO>> getPage(@RequestBody EncryptedReq<ScProjectPageParam> req) throws IllegalAccessException {
        ScProjectPageParam params = (ScProjectPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.scProjectService.getPage(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getPageByPagId"})
    @ApiOperation(value="\u6839\u636e\u5957\u9910id\uff0c\u83b7\u53d6\u9879\u76ee\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="packageId", value="\u5957\u9910id", paramType="query", required=true, dataTypeClass=String.class)})
    @DecryptAndVerify(decryptedClass=ScProjectPageParam.class)
    public Result<PageData<ScProjectDTO>> getPageByPagId(@RequestBody EncryptedReq<ScProjectPageParam> req) throws IllegalAccessException {
        ScProjectPageParam params = (ScProjectPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        AssertUtils.isBlank((String)params.getPackageId(), (String[])new String[]{"\u5957\u9910id"});
        PageData page = this.scProjectService.getPageByPagId(MapUtils.object2Map((Object)params));
        return new Result().ok((Object)page);
    }

    @PostMapping(value={"getListByPagId"})
    @ApiOperation(value="\u6839\u636e\u5957\u9910id\uff0c\u83b7\u53d6\u9879\u76ee\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ScProjectSearchParam.class)
    public Result<List<ScProjectDTO>> getListByPagId(@RequestBody EncryptedReq<ScProjectSearchParam> req) {
        ScProjectSearchParam param = (ScProjectSearchParam)req.getData();
        AssertUtils.isBlank((String)param.getPackageId(), (String[])new String[]{"\u5957\u9910id"});
        List list = this.scProjectService.getListByPagId(param.getPackageId());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u7b5b\u67e5\u9879\u76ee\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ScProjectSearchParam.class)
    public Result<List<ScProjectDTO>> getList(@RequestBody EncryptedReq<ScProjectSearchParam> req) throws IllegalAccessException {
        ScProjectSearchParam param = (ScProjectSearchParam)req.getData();
        List resList = this.scProjectService.getList(MapUtils.object2Map((Object)param));
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"getCheckProjectList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u76ee\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetCheckProjectSearchParam.class)
    public Result<List<ScProjectDTO>> getCheckProjectList(@RequestBody EncryptedReq<GetCheckProjectSearchParam> req) throws IllegalAccessException {
        GetCheckProjectSearchParam param = (GetCheckProjectSearchParam)req.getData();
        List resList = this.scProjectService.getCheckProjectList(param);
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"getTreeList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u76ee\u6811\u5f62\u7ed3\u6784\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ScProjectSearchParam.class)
    public Result<List<ScProjectTreeDTO>> getTreeList(@RequestBody EncryptedReq<ScProjectSearchParam> req) {
        ScProjectSearchParam param = (ScProjectSearchParam)req.getData();
        List resList = this.scProjectService.getTreeList(param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=ScProjectSearchParam.class)
    public Result<ScProjectDTO> getInfo(@RequestBody EncryptedReq<ScProjectSearchParam> req) {
        ScProjectSearchParam param = (ScProjectSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        ScProjectDTO dto = this.scProjectService.getInfo(param.getIdKey());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"getInfoByExamNo"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u53f7\uff0c\u83b7\u53d6\u9879\u76ee\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=GetInfoByExamNoParam.class)
    public Result<ScProjectDTO> getInfoByExamNo(@RequestBody EncryptedReq<GetInfoByExamNoParam> req) {
        GetInfoByExamNoParam param = (GetInfoByExamNoParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        ScProjectDTO dto = this.scProjectService.getInfoByExamNo(param.getExamNo(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"getRelationBdTemplateList"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u7684\u8868\u5355\u6a21\u677f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ScProjectSearchParam.class)
    public Result<List<BdTemplateDTO>> getRelationBdTemplateList(@RequestBody EncryptedReq<ScProjectSearchParam> req) {
        ScProjectSearchParam param = (ScProjectSearchParam)req.getData();
        AssertUtils.isBlank((String)param.getOrgCode(), (String[])new String[]{"\u673a\u6784code"});
        AssertUtils.isBlank((String)param.getExamineCode(), (String[])new String[]{"\u68c0\u67e5\u9879\u76eecode"});
        List dto = this.scProjectService.getRelationBdTemplateList(param.getOrgCode(), param.getExamineCode());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"updateProject"})
    @ApiOperation(value="\u4fee\u6539\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u4fee\u6539\u68c0\u67e5\u9879\u76ee", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=2, logType=1)
    @DecryptAndVerify(decryptedClass=ScProjectDTO.class)
    public Result updateProject(@RequestBody EncryptedReq<ScProjectDTO> req) {
        ScProjectDTO dto = (ScProjectDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        return this.scProjectService.updateProject(dto);
    }

    @PostMapping(value={"saveProject"})
    @ApiOperation(value="\u65b0\u589e\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u65b0\u589e\u7b5b\u67e5\u9879\u76ee", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=ScProjectDTO.class)
    public Result saveProject(@RequestBody EncryptedReq<ScProjectDTO> req) {
        ScProjectDTO dto = (ScProjectDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.scProjectService.saveProject(dto);
    }

    @PostMapping(value={"switchZsFlag"})
    @ApiOperation(value="\u5207\u6362\u9879\u76ee\u77e5\u8bc6\u5e93\u72b6\u6001")
    @LogOperation(value="\u5207\u6362\u9879\u76ee\u77e5\u8bc6\u5e93\u72b6\u6001", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=1, logType=1)
    @DecryptAndVerify(decryptedClass=SwitchProjectZsFlagDTO.class)
    public Result switchZsFlag(@RequestBody EncryptedReq<SwitchProjectZsFlagDTO> req) {
        SwitchProjectZsFlagDTO dto = (SwitchProjectZsFlagDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.scProjectService.switchZsFlag(dto);
        return new Result();
    }

    @PostMapping(value={"deleteProject"})
    @ApiOperation(value="\u5220\u9664\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u5220\u9664\u68c0\u67e5\u9879\u76ee", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=DelProjectParam.class)
    public Result deleteProject(@RequestBody EncryptedReq<DelProjectParam> req) {
        DelProjectParam param = (DelProjectParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        this.scProjectService.deleteProject(param.getIdKey());
        return new Result();
    }

    @PostMapping(value={"changeProjectEnabled"})
    @ApiOperation(value="\u4fee\u6539\u68c0\u67e5\u9879\u76ee\u72b6\u6001")
    @LogOperation(value="\u4fee\u6539\u68c0\u67e5\u9879\u76ee\u72b6\u6001", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ChangeProjectEnabledParam.class)
    public Result changeProjectEnabled(@RequestBody EncryptedReq<ChangeProjectEnabledParam> req) {
        ChangeProjectEnabledParam param = (ChangeProjectEnabledParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        this.scProjectService.changeProjectEnabled(param);
        return new Result();
    }

    @PostMapping(value={"getKnowByStandardCode"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u9879\u76ee\u83b7\u53d6\u77e5\u8bc6\u5e93\u5185\u5bb9")
    @DecryptAndVerify(decryptedClass=GetKnowParam.class)
    public Result getKnowByStandardCode(@RequestBody EncryptedReq<GetKnowParam> req) {
        GetKnowParam param = (GetKnowParam)req.getData();
        AssertUtils.isBlank((String)param.getStandardCode(), (String[])new String[]{"\u6807\u51c6\u540d\u79f0code"});
        List list = this.scProjectService.getKnowByStandardCode(param.getStandardCode());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f")
    public void export(HttpServletResponse response) throws Exception {
        ExcelUtils.exportExcelToTarget((HttpServletResponse)response, null, (String)"\u9879\u76ee\u5217\u8868", new ArrayList(), ScProjectExcel.class);
    }

    @PostMapping(value={"uploadExamItemExcel"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u68c0\u67e5\u9879\u76eeexcel")
    @LogOperation(value="\u4e0a\u4f20\u68c0\u67e5\u9879\u76eeexcel", module="\u68c0\u67e5\u9879\u76ee\u7ba1\u7406", operationType=1)
    public Result uploadExamItemExcel(@RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="orgCode") String orgCode) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList list = new ArrayList();
        EasyExcel.read((InputStream)file.getInputStream(), ScProjectExcel.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).doReadAll();
        this.scProjectService.batchSaveByExcel(list);
        return new Result();
    }

    @PostMapping(value={"getProjectListByExcel"})
    @ApiOperation(value="\u8bfb\u53d6excel\u4e2d\u7684\u6570\u636e")
    public Result getProjectListByExcel(@RequestPart(value="file", required=true) MultipartFile file) throws IOException {
        ArrayList list = new ArrayList();
        EasyExcel.read((InputStream)file.getInputStream(), ScProjectExcel.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).doReadAll();
        return new Result().ok(list);
    }

    @PostMapping(value={"getExamItemStatusList"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u9879\u76ee\u72b6\u6001\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getExamItemStatusList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.scProjectService.getExamItemStatusList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    static /* synthetic */ ScProjectService access$000(ScProjectController x0) {
        return x0.scProjectService;
    }
}

