/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.register.controller;

import cn.hutool.core.collection.CollUtil;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.DynamicExcelUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dict.param.DictMenuFieldSearchParam;
import io.huimu.modules.dict.service.DictMenuFieldDeviceService;
import io.huimu.modules.register.param.ExportExamItemParam;
import io.huimu.modules.register.param.GetAutoMatchPatientListParam;
import io.huimu.modules.register.param.GetExamItemPageParam;
import io.huimu.modules.register.param.GetHandCancelPatientPageParam;
import io.huimu.modules.register.param.GetHandleOperaMatchPatientListParam;
import io.huimu.modules.register.param.GetHandleOperaMatchPatientPageParam;
import io.huimu.modules.register.param.RegisterItemParam;
import io.huimu.modules.register.param.UpdateExamStatusParam;
import io.huimu.modules.register.param.getExamItemListParam;
import io.huimu.modules.register.service.RegisterItemService;
import io.huimu.modules.register.vo.CheckCountFormartVO;
import io.huimu.modules.register.vo.OneKeyTansExamVO;
import io.huimu.modules.register.vo.RegisterExamInfoVO;
import io.huimu.modules.register.vo.RegisterItemInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/register/item"})
@Api(tags={"\u68c0\u67e5\u9879\u7ba1\u7406"})
public class RegisterItemController {
    @Autowired
    private RegisterItemService registerItemService;
    @Autowired
    private DictMenuFieldDeviceService dictMenuFieldDeviceService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetExamItemPageParam.class)
    public Result<PageData<RegisterExamInfoVO>> page(@RequestBody EncryptedReq<GetExamItemPageParam> req) throws IllegalAccessException {
        GetExamItemPageParam params = (GetExamItemPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.registerItemService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"getAutoMatchPatient"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u52a8\u5339\u914d\u60a3\u8005\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetAutoMatchPatientListParam.class)
    public Result<List<OneKeyTansExamVO>> getAutoMatchPatient(@RequestBody EncryptedReq<GetAutoMatchPatientListParam> req) throws IllegalAccessException {
        GetAutoMatchPatientListParam params = (GetAutoMatchPatientListParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        List list = this.registerItemService.getAutoMatchPatient(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getHandleOperaMatchPatientPage"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u52a8\u5339\u914d\u60a3\u8005\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetHandleOperaMatchPatientPageParam.class)
    public Result<PageData<OneKeyTansExamVO>> getHandleOperaMatchPatientPage(@RequestBody EncryptedReq<GetHandleOperaMatchPatientPageParam> req) throws IllegalAccessException {
        GetHandleOperaMatchPatientPageParam params = (GetHandleOperaMatchPatientPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        PageData list = this.registerItemService.getHandleOperaMatchPatientPage(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getHandleOperaMatchPatientList"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u52a8\u5339\u914d\u60a3\u8005\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetHandleOperaMatchPatientListParam.class)
    public Result<List<OneKeyTansExamVO>> getHandleOperaMatchPatientList(@RequestBody EncryptedReq<GetHandleOperaMatchPatientListParam> req) throws IllegalAccessException {
        GetHandleOperaMatchPatientListParam params = (GetHandleOperaMatchPatientListParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        List list = this.registerItemService.getHandleOperaMatchPatientList(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getHandCancelPatientList"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u52a8\u53d6\u6d88\u5173\u8054\u6587\u4ef6\u7684\u60a3\u8005\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetHandCancelPatientPageParam.class)
    public Result<PageData<RegisterExamInfoVO>> getHandCancelPatientList(@RequestBody EncryptedReq<GetHandCancelPatientPageParam> req) throws IllegalAccessException {
        GetHandCancelPatientPageParam params = (GetHandCancelPatientPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData list = this.registerItemService.getHandCancelPatientList(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"cancelExamItem"})
    @ApiOperation(value="\u53d6\u6d88\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u53d6\u6d88\u68c0\u67e5\u9879\u76ee", module="\u68c0\u67e5\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=UpdateExamStatusParam.class)
    public Result cancelExamItem(@RequestBody EncryptedReq<UpdateExamStatusParam> req) {
        UpdateExamStatusParam dto = (UpdateExamStatusParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.registerItemService.cancelExamItem(dto);
        return new Result();
    }

    @PostMapping(value={"callExamItemHj"})
    @ApiOperation(value="\u547c\u53eb\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u547c\u53eb\u68c0\u67e5\u9879\u76ee", module="\u68c0\u67e5\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=UpdateExamStatusParam.class)
    public Result callExamItemHj(@RequestBody EncryptedReq<UpdateExamStatusParam> req) {
        UpdateExamStatusParam dto = (UpdateExamStatusParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.registerItemService.callExamItemHj(dto);
        return new Result();
    }

    @PostMapping(value={"getExamItemList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u76ee\u5217\u8868")
    @DecryptAndVerify(decryptedClass=getExamItemListParam.class)
    public Result getExamItemList(@RequestBody EncryptedReq<getExamItemListParam> req) {
        getExamItemListParam dto = (getExamItemListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.registerItemService.getExamItemList(dto.getRisNo());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getExamItemListWithLog"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u76ee\u5217\u8868--\u5305\u542b\u53d6\u6d88\u7684\u9879\u76ee\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=getExamItemListParam.class)
    public Result getExamItemListWithLog(@RequestBody EncryptedReq<getExamItemListParam> req) {
        getExamItemListParam dto = (getExamItemListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.registerItemService.getExamItemListWithLog(dto.getRisNo());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"checkCount"})
    @ApiOperation(value="\u68c0\u67e5\u8ba1\u6570")
    @DecryptAndVerify(decryptedClass=GetExamItemPageParam.class)
    public Result<CheckCountFormartVO> checkCount(@RequestBody EncryptedReq<GetExamItemPageParam> req) throws IllegalAccessException {
        GetExamItemPageParam params = (GetExamItemPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        CheckCountFormartVO vo = this.registerItemService.checkCount(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"updateOneKeyTransStatus"})
    @ApiOperation(value="\u4fee\u6539\u4e00\u952e\u4f20\u8f93\u72b6\u6001")
    @DecryptAndVerify(decryptedClass=RegisterItemParam.class)
    @LogOperation(value="\u4fee\u6539\u4e00\u952e\u4f20\u8f93\u72b6\u6001", module="\u68c0\u67e5\u7ba1\u7406", operationType=2)
    public Result updateOneKeyTransStatus(@RequestBody EncryptedReq<RegisterItemParam> req) {
        RegisterItemParam params = (RegisterItemParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        this.registerItemService.updateOneKeyTransStatus(params.getExamNo());
        return new Result();
    }

    @PostMapping(value={"finishExamItem"})
    @ApiOperation(value="\u5b8c\u6210\u68c0\u67e5\u9879\u76ee")
    @LogOperation(value="\u5b8c\u6210\u68c0\u67e5\u9879\u76ee", module="\u68c0\u67e5\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=UpdateExamStatusParam.class)
    public Result finishExamItem(@RequestBody EncryptedReq<UpdateExamStatusParam> req) {
        UpdateExamStatusParam dto = (UpdateExamStatusParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.registerItemService.finishExamItem(dto);
        return new Result();
    }

    @PostMapping(value={"getExamItemInfo"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u9879\u76ee\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=RegisterItemParam.class)
    public Result getExamItemInfo(@RequestBody EncryptedReq<RegisterItemParam> req) {
        RegisterItemParam params = (RegisterItemParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        RegisterItemInfoVO vo = this.registerItemService.getExamItemInfo(params.getExamNo());
        return new Result().ok((Object)vo);
    }

    @PostMapping(value={"export"})
    @ApiOperation(value="\u5bfc\u51fa\u68c0\u67e5\u9879\u76ee")
    @DecryptAndVerify(decryptedClass=ExportExamItemParam.class)
    public void postExportOpera(@RequestBody EncryptedReq<ExportExamItemParam> req, HttpServletResponse response) throws Exception {
        ExportExamItemParam param = (ExportExamItemParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[]{DefaultGroup.class});
        DictMenuFieldSearchParam fieldSearchParam = new DictMenuFieldSearchParam();
        fieldSearchParam.setDeviceId(param.getDeviceId());
        fieldSearchParam.setMenuUrl(param.getMenuUrl());
        List dictMenuFieldVOS = this.dictMenuFieldDeviceService.getDeviceDynamicTitleList(fieldSearchParam);
        if (CollUtil.isEmpty((Collection)dictMenuFieldVOS)) {
            throw new RenException("\u8868\u5934\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List list = this.registerItemService.getExportItemList(MapUtils.object2Map((Object)param));
        DynamicExcelUtils.export((HttpServletResponse)response, (String)("\u68c0\u67e5\u4fe1\u606f-" + DateUtils.format((Date)new Date())), (List)dictMenuFieldVOS, (List)list);
    }
}

