/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.qgpatientview.service.impl;

import cn.hutool.core.collection.CollUtil;
import io.huimu.modules.qgpatientview.dao.Patient360Dao;
import io.huimu.modules.qgpatientview.service.Patient360Service;
import io.huimu.modules.qgpatientview.vo.EchartsLineVO;
import io.huimu.modules.qgpatientview.vo.EchartsVO;
import io.huimu.modules.qgpatientview.vo.HistoryVO;
import io.huimu.modules.qgpatientview.vo.IopVO;
import io.huimu.modules.qgpatientview.vo.RegisterExamItemVO;
import io.huimu.modules.qgpatientview.vo.TimeAxisItemVO;
import io.huimu.modules.qgpatientview.vo.YanYaAndYanZhouVO;
import io.huimu.modules.transfer.service.TransferService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Patient360ServiceImpl
implements Patient360Service {
    @Autowired
    private Patient360Dao patient360Dao;
    @Autowired
    private TransferService transferService;

    public List<Map<String, Object>> getTimeAxisData(String patientId) {
        List list = null;
        list = this.patient360Dao.getTimeAxisData(patientId);
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        Map<String, List<TimeAxisItemVO>> groupMap = list.stream().collect(Collectors.groupingBy(TimeAxisItemVO::getYear));
        for (String key : groupMap.keySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("year", key);
            List<TimeAxisItemVO> childList = groupMap.get(key);
            Map<String, List<TimeAxisItemVO>> datGroup = childList.stream().collect(Collectors.groupingBy(TimeAxisItemVO::getOpDate));
            ArrayList dayList = new ArrayList();
            for (String day : datGroup.keySet()) {
                HashMap<String, Object> dayMap = new HashMap<String, Object>();
                dayMap.put("date", day);
                dayMap.put("itemList", datGroup.get(day));
                dayList.add(dayMap);
            }
            dayList.sort((o1, o2) -> o2.get("date").toString().compareTo(o1.get("date").toString()));
            map.put("data", dayList);
            resList.add(map);
        }
        resList.sort((a, b) -> Integer.valueOf(b.get("year").toString()).compareTo(Integer.valueOf(a.get("year").toString())));
        return resList;
    }

    public List getTimeAxisNodeInfo(String groupName, String date, String patientId) {
        if (groupName.equalsIgnoreCase("\u624b\u672f")) {
            return this.patient360Dao.getOperation(patientId, date);
        }
        if (groupName.equalsIgnoreCase("\u8bca\u65ad")) {
            return this.patient360Dao.getDiagnose(patientId, date);
        }
        if (groupName.equalsIgnoreCase("\u533b\u5631")) {
            return this.patient360Dao.getMedication(patientId, date);
        }
        if (groupName.contains("\u9662")) {
            return this.patient360Dao.getInHospital(patientId, date);
        }
        if (groupName.equalsIgnoreCase("\u7279\u68c0")) {
            List list = this.patient360Dao.getExamine(patientId, date);
            if (CollUtil.isNotEmpty((Collection)list)) {
                for (RegisterExamItemVO vo : list) {
                    vo.setOutLink(this.patient360Dao.getExamItemOutlink(vo.getExamNo()));
                }
            }
            return list;
        }
        return new ArrayList();
    }

    public List<HistoryVO> getHistory(String patientId, String orgCode) {
        List list = this.patient360Dao.getHistory(patientId);
        for (HistoryVO historyVo : list) {
            if (StringUtils.isBlank((CharSequence)historyVo.getJzNumber())) continue;
            historyVo.setJcInfoVO(this.patient360Dao.getJcInfoByJzNumber(patientId, historyVo.getJzNumber()));
        }
        return list;
    }

    public ConcurrentHashMap<String, Object> getVaAndIopAndRefLast(String patientId) throws InterruptedException {
        ArrayList<Future> futureList = new ArrayList<Future>();
        ConcurrentHashMap<String, Object> resMap = new ConcurrentHashMap<String, Object>();
        Future shili = this.transferService.getShiLiGen(patientId, resMap);
        futureList.add(shili);
        Future yanya = this.transferService.getYanyaGen(patientId, resMap);
        futureList.add(yanya);
        Future dNYanguang = this.transferService.getDNYanguang(patientId, resMap);
        futureList.add(dNYanguang);
        Future zJYanguang = this.transferService.getZJYanguang(patientId, resMap);
        futureList.add(zJYanguang);
        for (Future future : futureList) {
            while (!future.isDone() || future.isCancelled()) {
                Thread.sleep(1L);
            }
        }
        return resMap;
    }

    public YanYaAndYanZhouVO getYanZouAndYanYaData(String patientId) {
        List yzList;
        EchartsLineVO os;
        EchartsLineVO od;
        YanYaAndYanZhouVO vo = new YanYaAndYanZhouVO();
        ArrayList<EchartsLineVO> yyOdList = new ArrayList<EchartsLineVO>();
        ArrayList<EchartsLineVO> yyOsList = new ArrayList<EchartsLineVO>();
        ArrayList<EchartsLineVO> yzOdList = new ArrayList<EchartsLineVO>();
        ArrayList<EchartsLineVO> yzOsList = new ArrayList<EchartsLineVO>();
        List yyList = this.patient360Dao.getYanyaList(patientId);
        if (CollUtil.isNotEmpty((Collection)yyList)) {
            for (IopVO iop : yyList) {
                od = new EchartsLineVO();
                os = new EchartsLineVO();
                od.setExamTime(iop.getExamTime());
                os.setExamTime(iop.getExamTime());
                od.setVal(iop.getOdIop());
                os.setVal(iop.getOsIop());
                yyOdList.add(od);
                yyOsList.add(os);
            }
            vo.setYanYaOd(yyOdList);
            vo.setYanYaOs(yyOsList);
        }
        if (CollUtil.isNotEmpty((Collection)(yzList = this.patient360Dao.getYanZhouList(patientId)))) {
            for (EchartsVO e : yzList) {
                if (e.getEyeType().equalsIgnoreCase("OD")) {
                    od = new EchartsLineVO();
                    od.setVal(e.getVal());
                    od.setExamTime(e.getExamTime());
                    yzOdList.add(od);
                    continue;
                }
                os = new EchartsLineVO();
                os.setVal(e.getVal());
                os.setExamTime(e.getExamTime());
                yzOsList.add(os);
            }
            vo.setYanZhouOd(yzOdList);
            vo.setYanZhouOs(yzOsList);
        }
        return vo;
    }
}

