/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patientset.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.IdsParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.patientset.dto.PatientSetDTO;
import io.huimu.modules.patientset.entity.PatientSetEntity;
import io.huimu.modules.patientset.param.PatientSetPageParam;
import io.huimu.modules.patientset.service.PatientSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patient/set"})
@Api(tags={"\u60a3\u8005\u8bbe\u7f6e\u7ba1\u7406"})
public class PatientSetController {
    @Autowired
    private PatientSetService patientSetService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=PatientSetPageParam.class)
    public Result<PageData<PatientSetDTO>> page(@RequestBody EncryptedReq<PatientSetPageParam> req) throws IllegalAccessException {
        PatientSetPageParam data = (PatientSetPageParam)req.getData();
        Map params = MapUtils.object2Map((Object)data);
        PageData page = this.patientSetService.page(params);
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u6dfb\u52a0\u60a3\u8005\u8bbe\u7f6e")
    @LogOperation(value="\u6dfb\u52a0\u60a3\u8005\u8bbe\u7f6e", module="\u60a3\u8005\u8bbe\u7f6e\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=PatientSetDTO.class)
    public Result save(@RequestBody EncryptedReq<PatientSetDTO> req) {
        PatientSetDTO dto = (PatientSetDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.patientSetService.save(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        PatientSetEntity entity = (PatientSetEntity)this.patientSetService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)entity, PatientSetDTO.class));
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u60a3\u8005\u8bbe\u7f6e")
    @LogOperation(value="\u4fee\u6539\u60a3\u8005\u8bbe\u7f6e", module="\u60a3\u8005\u8bbe\u7f6e\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=PatientSetDTO.class)
    public Result update(@RequestBody EncryptedReq<PatientSetDTO> req) {
        PatientSetDTO dto = (PatientSetDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.patientSetService.update(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u60a3\u8005\u8bbe\u7f6e")
    @LogOperation(value="\u5220\u9664\u60a3\u8005\u8bbe\u7f6e", module="\u60a3\u8005\u8bbe\u7f6e\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=IdsParam.class)
    public Result delete(@RequestBody EncryptedReq<IdsParam> req) {
        IdsParam dto = (IdsParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.patientSetService.deleteBatchIds((Collection)dto.getId());
        return new Result();
    }
}

