/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patientcollect.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.patientcollect.dao.PatientCollectDao;
import io.huimu.modules.patientcollect.dto.PatientCollectDTO;
import io.huimu.modules.patientcollect.dto.PatientCollectTreeDTO;
import io.huimu.modules.patientcollect.entity.PatientCollectEntity;
import io.huimu.modules.patientcollect.service.PatientCollectService;
import io.huimu.modules.patientcollect.service.PatientCollectTreeService;
import io.huimu.modules.patientcollect.vo.PatientCollectVO;
import io.huimu.modules.security.user.SecurityUser;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatientCollectServiceImpl
extends BaseServiceImpl<PatientCollectDao, PatientCollectEntity>
implements PatientCollectService {
    @Autowired
    private PatientCollectTreeService treeService;

    public void addTree(PatientCollectTreeDTO dto) {
        this.treeService.addTree(dto);
    }

    public List<PatientCollectTreeDTO> getTree(String orgCode) {
        return this.treeService.getTree(orgCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTree(String treeId) {
        List allIds = this.treeService.getAllIdByTreeId(treeId);
        allIds.add(treeId);
        ((PatientCollectDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"TREE_ID", (Collection)allIds));
        this.treeService.deleteBatchIds((Collection)allIds);
    }

    public void collectPatient(PatientCollectDTO dto) {
        PatientCollectEntity entity = (PatientCollectEntity)ConvertUtils.sourceToTarget((Object)dto, PatientCollectEntity.class);
        if (StringUtils.isNotBlank((CharSequence)entity.getId())) {
            this.updateById((Object)entity);
        } else {
            Integer count = ((PatientCollectDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tree_id", (Object)dto.getTreeId())).eq((Object)"patient_id", (Object)dto.getPatientId())).eq((Object)"org_code", (Object)dto.getOrgCode()));
            if (count == 0) {
                entity.setCreateCode(SecurityUser.getEmployeeId());
                entity.setCreateName(SecurityUser.getUser().getRealName());
                this.insert((Object)entity);
            }
        }
    }

    public void deletePatient(String id) {
        ((PatientCollectDao)this.baseDao).deleteById((Serializable)((Object)id));
    }

    public List<PatientCollectVO> getPatientList(String treeId) {
        List resList = ((PatientCollectDao)this.baseDao).getPatientList(treeId);
        return resList;
    }
}

