/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patient.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.patient.dto.PatientArchiveDTO;
import io.huimu.modules.patient.param.GetArchiveListParam;
import io.huimu.modules.patient.service.PatientArchiveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archive"})
@Api(tags={"\u60a3\u8005\u6863\u6848\u7ba1\u7406"})
public class PatientArchiveController {
    @Autowired
    private PatientArchiveService patientArchiveService;

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u6863\u6848\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetArchiveListParam.class)
    public Result<List<PatientArchiveDTO>> getList(@RequestBody EncryptedReq<GetArchiveListParam> req) {
        GetArchiveListParam data = (GetArchiveListParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        List resList = this.patientArchiveService.getList(data.getPatientId(), data.getPatientIdNumber());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"addArchive"})
    @ApiOperation(value="\u6dfb\u52a0\u6863\u6848")
    @LogOperation(value="\u6dfb\u52a0\u6863\u6848", module="\u60a3\u8005\u6863\u6848\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=PatientArchiveDTO.class)
    public Result addArchive(@RequestBody EncryptedReq<PatientArchiveDTO> req) {
        PatientArchiveDTO dto = (PatientArchiveDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        return this.patientArchiveService.addArchive(dto);
    }

    @PostMapping(value={"deleteArchive"})
    @ApiOperation(value="\u5220\u9664\u6863\u6848")
    @LogOperation(value="\u5220\u9664\u6863\u6848", module="\u60a3\u8005\u6863\u6848\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result deleteArchive(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"\u6863\u6848"});
        return this.patientArchiveService.deleteArchive(param.getId());
    }
}

