/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.outside.service;

import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import io.huimu.common.config.entity.SmsRequestEntity;
import io.huimu.common.config.entity.SmsResponseEntity;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.opera.entity.QgOperaSmsLogEntity;
import io.huimu.modules.opera.service.QgOperaSmsLogService;
import io.huimu.modules.opera.vo.QgOperaBeforeVO;
import io.huimu.modules.sys.service.SysSystemConfService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SendMessageService {
    @Value(value="${hospitalCode}")
    private String hospitalCode;
    @Autowired
    private QgOperaSmsLogService operaSmsLogService;
    @Autowired
    private SysSystemConfService sysSystemConfService;

    @Async
    public void sendOperaMessage(QgOperaBeforeVO vo) {
        String sendMessageUrl = this.sysSystemConfService.getConfValue("100040", "");
        if (StringUtils.isNotBlank((CharSequence)sendMessageUrl)) {
            if (this.hospitalCode.equalsIgnoreCase("LOCAL")) {
                this.sendLocalOperaMessage(vo);
            } else if (this.hospitalCode.equalsIgnoreCase("SD_WFYKYY")) {
                this.sendSdWfOperaMessage(vo, sendMessageUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalOperaMessage(QgOperaBeforeVO vo) {
        QgOperaSmsLogEntity logEntity = (QgOperaSmsLogEntity)ConvertUtils.sourceToTarget((Object)vo, QgOperaSmsLogEntity.class);
        if (StringUtils.isNotBlank((CharSequence)vo.getPatientPhone()) && StringUtils.isNotBlank((CharSequence)vo.getSmsContent())) {
            SmsRequestEntity smsRequest = new SmsRequestEntity("b1agb1", DigestUtil.md5Hex((String)"92708006"), vo.getPatientPhone(), "0", "\u3010\u5357\u4eac\u6167\u76ee\u3011 " + vo.getSmsContent(), "", "", "");
            try {
                HttpResponse httpResponse = HttpRequest.post((String)"http://open2.ucpaas.com/sms-server/sendsms").body(JSONUtil.toJsonStr((Object)smsRequest)).execute();
                SmsResponseEntity smsResponse = (SmsResponseEntity)JSONUtil.toBean((String)httpResponse.body(), SmsResponseEntity.class);
                if (null != smsResponse && smsResponse.getCode() == 0) {
                    logEntity.setStatus(Integer.valueOf(1));
                } else {
                    logEntity.setStatus(Integer.valueOf(2));
                    logEntity.setFailMsg(smsResponse.getMsg());
                }
            }
            catch (Exception e) {
                logEntity.setStatus(Integer.valueOf(2));
                logEntity.setFailMsg(e.getMessage());
            }
            finally {
                this.operaSmsLogService.insert((Object)logEntity);
            }
        }
    }

    private void sendSdWfOperaMessage(QgOperaBeforeVO vo, String sendMessageUrl) {
    }

    public Integer sendMessage(String patientPhone, String smsMessage) {
        String sendMessageUrl = this.sysSystemConfService.getConfValue("100040", "");
        if (StringUtils.isNotBlank((CharSequence)sendMessageUrl)) {
            if (this.hospitalCode.equalsIgnoreCase("LOCAL")) {
                return this.sendLocalMessage(patientPhone, smsMessage);
            }
            if (this.hospitalCode.equalsIgnoreCase("SD_WFYKYY")) {
                return this.sendSdwfMessage(patientPhone, smsMessage, sendMessageUrl);
            }
            return 0;
        }
        return 0;
    }

    private Integer sendSdwfMessage(String patientPhone, String smsMessage, String sendMessageUrl) {
        return 1;
    }

    private Integer sendLocalMessage(String patientPhone, String smsMessage) {
        if (StringUtils.isNotBlank((CharSequence)patientPhone) && StringUtils.isNotBlank((CharSequence)smsMessage)) {
            SmsRequestEntity smsRequest = new SmsRequestEntity("b1agb1", DigestUtil.md5Hex((String)"92708006"), patientPhone, "0", "\u3010\u5357\u4eac\u6167\u76ee\u3011 " + smsMessage, "", "", "");
            try {
                HttpResponse httpResponse = HttpRequest.post((String)"http://open2.ucpaas.com/sms-server/sendsms").body(JSONUtil.toJsonStr((Object)smsRequest)).execute();
                SmsResponseEntity smsResponse = (SmsResponseEntity)JSONUtil.toBean((String)httpResponse.body(), SmsResponseEntity.class);
                if (null != smsResponse && smsResponse.getCode() == 0) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }
}

