/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.outside.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.huimu.common.exception.RenException;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.Result;
import io.huimu.modules.hisregister.dto.HisRegisterDTO;
import io.huimu.modules.outside.vo.njyk.NjykHisResponseEntity;
import io.huimu.modules.outside.vo.njyk.NjykPatientVO;
import io.huimu.modules.patient.param.QueryHisPatientParam;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class QueryPatientService {
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Value(value="${hospitalCode}")
    private String hospitalCode;

    public Result queryHisPatient(QueryHisPatientParam data) {
        String queryHisPatientUrl = this.sysSystemConfService.getConfValue("100039", "");
        if (StringUtils.isNotBlank((CharSequence)queryHisPatientUrl)) {
            return this.queryNjykHisPatient(data.getPatientId(), data.getHospitalCode(), queryHisPatientUrl);
        }
        return new Result().error("\u67e5\u8be2\u8fde\u63a5\u914d\u7f6e\u9519\u8bef");
    }

    private Result queryNjykHisPatient(String patientId, String hospitalCode, String queryUrl) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sourcePatientId", patientId);
        param.put("hospitalCode", hospitalCode);
        param.put("registerUserId", SecurityUser.getEmployeeId());
        param.put("registerUserName", SecurityUser.getUser().getRealName());
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseResult = null;
        try {
            System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u83b7\u53d6his\u60a3\u8005\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)httpEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue}));
            responseResult = restTemplate.exchange(queryUrl, HttpMethod.POST, httpEntity, NjykHisResponseEntity.class, new Object[0]);
        }
        catch (Exception e) {
            throw new RenException(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".....\u83b7\u53d6his\u60a3\u8005\u8c03\u7528\u5931\u8d25\uff1a\u4fe1\u606f\uff1a" + e.getMessage());
        }
        if (null != responseResult) {
            NjykHisResponseEntity hisResponseEntity = (NjykHisResponseEntity)responseResult.getBody();
            if (null != hisResponseEntity) {
                int code = hisResponseEntity.getCode();
                if (code == 0) {
                    return new Result();
                }
                return new Result().error(hisResponseEntity.getMsg());
            }
            return new Result().error("\u67e5\u8be2his\u60a3\u8005\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return new Result().error("\u67e5\u8be2his\u60a3\u8005\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
    }

    public List<HisRegisterDTO> queryHisQgPatient(QueryHisPatientParam data) {
        String queryHisPatientUrl = this.sysSystemConfService.getConfValue("100045", "");
        if (StringUtils.isNotBlank((CharSequence)queryHisPatientUrl)) {
            queryHisPatientUrl = queryHisPatientUrl + "?sourcePatientId=" + data.getPatientId() + "&hospitalCode=" + data.getHospitalCode();
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json");
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseResult = null;
            try {
                System.out.println(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ",\u83b7\u53d6his\u60a3\u8005\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)httpEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue}));
                responseResult = restTemplate.exchange(queryHisPatientUrl, HttpMethod.GET, httpEntity, NjykHisResponseEntity.class, new Object[0]);
            }
            catch (Exception e) {
                throw new RenException(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + ".....\u83b7\u53d6his\u60a3\u8005\u8c03\u7528\u5931\u8d25\uff1a\u4fe1\u606f\uff1a" + e.getMessage());
            }
            if (null != responseResult) {
                NjykHisResponseEntity hisResponseEntity = (NjykHisResponseEntity)responseResult.getBody();
                if (null != hisResponseEntity) {
                    int code = hisResponseEntity.getCode();
                    if (code == 0) {
                        NjykPatientVO njykPatientVO = hisResponseEntity.getData();
                        HisRegisterDTO patient = new HisRegisterDTO();
                        patient.setPatientId(njykPatientVO.getPatientId());
                        patient.setPatientIdNumber(njykPatientVO.getIdCard());
                        patient.setPatientName(njykPatientVO.getName());
                        patient.setPatientSex(njykPatientVO.getSex());
                        if (StringUtils.isNotBlank((CharSequence)njykPatientVO.getBirthday())) {
                            patient.setPatientBirthday(DateUtils.stringToDate((String)njykPatientVO.getBirthday(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        patient.setJzNumber(njykPatientVO.getJzNumber());
                        patient.setGhKsCode(njykPatientVO.getGhDoctorCode());
                        patient.setGhKsName(njykPatientVO.getGhDeptName());
                        patient.setGhDoctorCode(njykPatientVO.getGhDoctorCode());
                        patient.setGhDoctorName(njykPatientVO.getGhDoctorName());
                        if (StringUtils.isNotBlank((CharSequence)njykPatientVO.getHisTime())) {
                            patient.setHisTime(DateUtils.stringToDate((String)njykPatientVO.getHisTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        patient.setPatientSource(njykPatientVO.getSource());
                        patient.setHisFlag(njykPatientVO.getHisFlag());
                        patient.setPatientPhone(njykPatientVO.getPhone());
                        patient.setPatientAddress(njykPatientVO.getAddress());
                        patient.setPatientJg(njykPatientVO.getBirthplace());
                        patient.setPatientMz(njykPatientVO.getNation());
                        patient.setPatientZy(njykPatientVO.getProfession());
                        patient.setMzNumber(njykPatientVO.getMzNumber());
                        patient.setHospitalCode(data.getHospitalCode());
                        return Arrays.asList(patient);
                    }
                    throw new RenException(hisResponseEntity.getMsg());
                }
                throw new RenException("\u67e5\u8be2his\u60a3\u8005\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            throw new RenException("\u67e5\u8be2his\u60a3\u8005\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a");
        }
        throw new RenException("\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }
}

