/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.opera.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.opera.dao.QgOperaDao;
import io.huimu.modules.opera.dto.BatchYuYueOperaDTO;
import io.huimu.modules.opera.dto.QgNumSourceDTO;
import io.huimu.modules.opera.dto.QgOperaDTO;
import io.huimu.modules.opera.dto.QgOperaStatusDTO;
import io.huimu.modules.opera.dto.SaveNoYuYueOperaDTO;
import io.huimu.modules.opera.entity.QgNumSourceEntity;
import io.huimu.modules.opera.entity.QgOperaEntity;
import io.huimu.modules.opera.param.CancelOperaParam;
import io.huimu.modules.opera.param.FinalOperaParam;
import io.huimu.modules.opera.param.UpdateOperaSortParam;
import io.huimu.modules.opera.service.QgNumSourceService;
import io.huimu.modules.opera.service.QgOperaService;
import io.huimu.modules.opera.service.QgOperaStatusLogService;
import io.huimu.modules.opera.vo.QgOperaBeforeVO;
import io.huimu.modules.opera.vo.QgOperaVO;
import io.huimu.modules.opera.vo.QgReservationPatientVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.wx.param.WxParam;
import io.huimu.modules.wx.service.WxService;
import io.huimu.modules.xj.service.XjService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QgOperaServiceImpl
extends BaseServiceImpl<QgOperaDao, QgOperaEntity>
implements QgOperaService {
    @Autowired
    private QgNumSourceService qgNumSourceService;
    @Autowired
    private QgOperaStatusLogService operaStatusLogService;
    @Autowired
    private XjService xjService;
    @Autowired
    private WxService wxService;
    @Value(value="${hospitalCode}")
    private String hospitalCode;

    public PageData<QgOperaVO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "operaName", "remark"});
        IPage page = this.getPage(params, "", false);
        List list = ((QgOperaDao)this.baseDao).getList(params);
        return this.getPageData(list, page.getTotal(), QgOperaVO.class);
    }

    public List<QgOperaVO> getExportOperaList(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "operaName", "remark"});
        List list = ((QgOperaDao)this.baseDao).getList(params);
        return ConvertUtils.sourceToTarget((Collection)list, QgOperaVO.class);
    }

    public PageData<QgOperaVO> getYuYuePage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientName", "patientId", "operaName", "remark"});
        IPage page = this.getPage(params, "", false);
        List list = ((QgOperaDao)this.baseDao).getYuYueList(params);
        return this.getPageData(list, page.getTotal(), QgOperaVO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOpera(QgOperaDTO dto) {
        QgOperaEntity entity = (QgOperaEntity)ConvertUtils.sourceToTarget((Object)dto, QgOperaEntity.class);
        entity.setCreateDate(new Date());
        if (null != dto.getCheckNumberSource() && dto.getCheckNumberSource() == 1) {
            if (StringUtils.isBlank((CharSequence)dto.getMainNumSourceId())) {
                throw new RenException("\u624b\u672f\u53f7\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            QgNumSourceDTO numSourceDTO = this.qgNumSourceService.getInfo(dto.getMainNumSourceId());
            if (null == numSourceDTO) {
                throw new RenException("\u624b\u672f\u533b\u751f\u53f7\u6e90\u4e0d\u5b58\u5728");
            }
            if (numSourceDTO.getStatus() == 1) {
                throw new RenException("\u624b\u672f\u533b\u751f\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
            }
            this.qgNumSourceService.batchUpdateSource(dto.getMainNumSourceId(), null, Integer.valueOf(1));
            entity.setOperaDate(numSourceDTO.getAppointmentDate());
            entity.setOperaTime(numSourceDTO.getAppointmentTime());
            entity.setMainDoctorCode(numSourceDTO.getDoctorCode());
            entity.setMainDoctorName(numSourceDTO.getDoctorName());
            entity.setIsMorOrAft(numSourceDTO.getMorOrAft());
        } else {
            entity.setMainNumSourceId(null);
            if (StringUtils.isNotBlank((CharSequence)dto.getOperaDate()) && StringUtils.isNotBlank((CharSequence)dto.getOperaTime())) {
                entity.setIsMorOrAft(DateUtils.judgeMorningOrAfternoon((Date)DateUtils.stringToDate((String)(dto.getOperaDate() + " " + dto.getOperaTime()), (String)"yyyy-MM-dd HH:mm:ss")));
            }
        }
        String maxOperaNumber = ((QgOperaDao)this.baseDao).selectMaxOperaNumber(DateUtils.format((Date)new Date()).replaceAll("-", ""));
        if (StringUtils.isNotBlank((CharSequence)maxOperaNumber)) {
            Long number = Long.valueOf(maxOperaNumber) + 1L;
            entity.setOperaNumber(String.valueOf(number));
        } else {
            entity.setOperaNumber(dto.getOperaDate().replaceAll("-", "") + "001");
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOperaDate())) {
            entity.setOperaStatus(Integer.valueOf(100));
        } else {
            entity.setOperaStatus(Integer.valueOf(0));
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOperaDate()) && StringUtils.isNotBlank((CharSequence)entity.getOperaTime())) {
            entity.setIsMorOrAft(DateUtils.judgeMorningOrAfternoon((Date)DateUtils.stringToDate((String)(entity.getOperaDate() + " " + entity.getOperaTime()), (String)"yyyy-MM-dd HH:mm:ss")));
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOperaDate())) {
            entity.setWeekday(DateUtils.getWeekByDay((Date)DateUtils.stringToDate((String)entity.getOperaDate(), (String)"yyyy-MM-dd")));
        }
        this.insert((Object)entity);
        if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            QgOperaDTO dbEntity = ((QgOperaDao)this.baseDao).getInfoById(entity.getId());
            String smsContent = ((QgOperaDao)this.baseDao).getYuyueSuccessSms(entity.getId());
            if (StringUtils.isNotBlank((CharSequence)smsContent)) {
                String messageId = "0pfrYOXAcUy0DoN9mCoQ3gzyoUq3qWHzxxaP3im_pz8";
                HashMap<String, WxParam> paramMap = new HashMap<String, WxParam>();
                paramMap.put("first", new WxParam("\u9884\u7ea6\u6210\u529f\u63d0\u9192"));
                paramMap.put("keyword1", new WxParam(dbEntity.getOrgName()));
                paramMap.put("keyword2", new WxParam(smsContent));
                paramMap.put("keyword3", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")));
                paramMap.put("remark", new WxParam("\u795d\u60a8\u65e9\u65e5\u5eb7\u590d"));
                this.wxService.sendMessage(messageId, paramMap, dbEntity.getPatientIdNumber(), null, Integer.valueOf(30), "\u624b\u672f\u9884\u7ea6\u6210\u529f", "\u624b\u672f\u9884\u7ea6\u6210\u529f");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOpera(QgOperaDTO dto) {
        String smsContent;
        QgNumSourceEntity sourceEntity;
        QgOperaDTO dbEntity = ((QgOperaDao)this.baseDao).getInfoById(dto.getId());
        if (null == dbEntity) {
            throw new RenException("\u6b64\u624b\u672f\u5df2\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dbEntity.getOperaStatus() == 400) {
            throw new RenException("\u624b\u672f\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        QgOperaEntity entity = (QgOperaEntity)ConvertUtils.sourceToTarget((Object)dto, QgOperaEntity.class);
        ArrayList<QgNumSourceEntity> numSourceEntities = new ArrayList<QgNumSourceEntity>();
        if (null != dto.getCheckNumberSource() && dto.getCheckNumberSource() == 1) {
            if (StringUtils.isBlank((CharSequence)dto.getMainNumSourceId())) {
                throw new RenException("\u624b\u672f\u53f7\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)dbEntity.getMainNumSourceId()) || !dto.getMainNumSourceId().equalsIgnoreCase(dbEntity.getMainNumSourceId())) {
                QgNumSourceDTO numSourceDTO = this.qgNumSourceService.getInfo(dto.getMainNumSourceId());
                if (null == numSourceDTO) {
                    throw new RenException("\u624b\u672f\u533b\u751f\u53f7\u6e90\u4e0d\u5b58\u5728");
                }
                if (numSourceDTO.getStatus() == 1) {
                    throw new RenException("\u624b\u672f\u533b\u751f\u53f7\u6e90\u5df2\u88ab\u9884\u7ea6");
                }
                if (StringUtils.isNotBlank((CharSequence)dbEntity.getMainNumSourceId())) {
                    sourceEntity = new QgNumSourceEntity();
                    sourceEntity.setId(dbEntity.getMainNumSourceId());
                    sourceEntity.setStatus(Integer.valueOf(0));
                    numSourceEntities.add(sourceEntity);
                }
                sourceEntity = new QgNumSourceEntity();
                sourceEntity.setId(dto.getMainNumSourceId());
                sourceEntity.setStatus(Integer.valueOf(1));
                numSourceEntities.add(sourceEntity);
                this.qgNumSourceService.updateBatchById(numSourceEntities);
                entity.setOperaDate(numSourceDTO.getAppointmentDate());
                entity.setOperaTime(numSourceDTO.getAppointmentTime());
                entity.setMainDoctorCode(numSourceDTO.getDoctorCode());
                entity.setMainDoctorName(numSourceDTO.getDoctorName());
                entity.setIsMorOrAft(DateUtils.judgeMorningOrAfternoon((Date)DateUtils.stringToDate((String)(entity.getOperaDate() + " " + entity.getOperaTime()), (String)"yyyy-MM-dd HH:mm:ss")));
            }
        } else {
            entity.setMainNumSourceId(null);
            if (StringUtils.isNotBlank((CharSequence)dto.getOperaDate()) && StringUtils.isNotBlank((CharSequence)dto.getOperaTime())) {
                entity.setIsMorOrAft(DateUtils.judgeMorningOrAfternoon((Date)DateUtils.stringToDate((String)(dto.getOperaDate() + " " + dto.getOperaTime()), (String)"yyyy-MM-dd HH:mm:ss")));
            }
            if (StringUtils.isNotBlank((CharSequence)dbEntity.getMainNumSourceId())) {
                sourceEntity = new QgNumSourceEntity();
                sourceEntity.setId(dbEntity.getMainNumSourceId());
                sourceEntity.setStatus(Integer.valueOf(0));
                this.qgNumSourceService.updateById((Object)sourceEntity);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getOperaDate())) {
            entity.setWeekday(DateUtils.getWeekByDay((Date)DateUtils.stringToDate((String)entity.getOperaDate(), (String)"yyyy-MM-dd")));
        }
        ((QgOperaDao)this.baseDao).updateOpera(entity);
        if (this.hospitalCode.equalsIgnoreCase("NJYK") && StringUtils.isNotBlank((CharSequence)(smsContent = ((QgOperaDao)this.baseDao).getYuyueSuccessSms(entity.getId())))) {
            String messageId = "0pfrYOXAcUy0DoN9mCoQ3gzyoUq3qWHzxxaP3im_pz8";
            HashMap<String, WxParam> paramMap = new HashMap<String, WxParam>();
            paramMap.put("first", new WxParam("\u9884\u7ea6\u6210\u529f\u63d0\u9192"));
            paramMap.put("keyword1", new WxParam(dbEntity.getOrgName()));
            paramMap.put("keyword2", new WxParam(smsContent));
            paramMap.put("keyword3", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")));
            paramMap.put("remark", new WxParam("\u795d\u60a8\u65e9\u65e5\u5eb7\u590d"));
            this.wxService.sendMessage(messageId, paramMap, dbEntity.getPatientIdNumber(), null, Integer.valueOf(31), "\u66f4\u65b0\u624b\u672f", "\u66f4\u65b0\u624b\u672f");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelOpera(CancelOperaParam dto) {
        if (dto.getCancelType() == 3) {
            this.deleteOpera(dto.getId());
        } else {
            QgOperaDTO dbEntity = ((QgOperaDao)this.baseDao).getInfoById(dto.getId());
            if (null == dbEntity) {
                throw new RenException("\u6b64\u624b\u672f\u5df2\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (dbEntity.getOperaStatus() == 400) {
                throw new RenException("\u624b\u672f\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u64cd\u4f5c");
            }
            if (dto.getCancelType() == 1) {
                ((QgOperaDao)this.baseDao).cancelOpera(dto.getId(), Integer.valueOf(0));
            } else {
                ((QgOperaDao)this.baseDao).cancelOpera(dto.getId(), Integer.valueOf(800));
            }
            this.qgNumSourceService.batchUpdateSource(dbEntity.getMainNumSourceId(), null, Integer.valueOf(0));
            if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
                String messageId = "M281-ZTK4Ur0W5Pm9yIKih9Uj4ngEPEvWqM3NcQv8E4";
                HashMap<String, WxParam> paramMap = new HashMap<String, WxParam>();
                paramMap.put("first", new WxParam("\u9884\u7ea6\u53d6\u6d88\u901a\u77e5"));
                paramMap.put("keynote1", new WxParam(dbEntity.getPatientName() + "\uff0c\u60a8\u5df2\u53d6\u6d88" + dbEntity.getOperaDate() + "\u7684\u624b\u672f"));
                paramMap.put("keynote2", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd")));
                paramMap.put("keynote3", new WxParam(dbEntity.getMainDoctorName()));
                paramMap.put("keynote4", new WxParam(dbEntity.getOrgName()));
                paramMap.put("remark", new WxParam("\u60a8\u5df2\u53d6\u6d88" + dbEntity.getOperaDate() + "\u7684\u624b\u672f"));
                this.wxService.sendMessage(messageId, paramMap, dbEntity.getPatientIdNumber(), null, Integer.valueOf(32), "\u53d6\u6d88\u624b\u672f", "\u53d6\u6d88\u624b\u672f");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOpera(String id) {
        QgOperaEntity dbEntity = (QgOperaEntity)((QgOperaDao)this.baseDao).selectById((Serializable)((Object)id));
        if (null == dbEntity) {
            throw new RenException("\u6b64\u624b\u672f\u5df2\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dbEntity.getOperaStatus() == 400) {
            throw new RenException("\u624b\u672f\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        this.deleteById((Serializable)((Object)id));
        this.qgNumSourceService.batchUpdateSource(dbEntity.getMainNumSourceId(), null, Integer.valueOf(0));
    }

    public List<QgOperaBeforeVO> getOperaRemindList() {
        return ((QgOperaDao)this.baseDao).getOperaRemindList();
    }

    public List<QgOperaBeforeVO> getOperaAfterRemindList() {
        return ((QgOperaDao)this.baseDao).getOperaAfterRemindList();
    }

    public List<QgOperaBeforeVO> getWxOperaRemindList() {
        return ((QgOperaDao)this.baseDao).getWxOperaRemindList();
    }

    public QgOperaDTO getInfo(String id) {
        return ((QgOperaDao)this.baseDao).getInfoById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOperaStatus(QgOperaStatusDTO dto) {
        QgOperaEntity entity = new QgOperaEntity();
        entity.setId(dto.getId());
        entity.setOperaStatus(dto.getOperaStatus());
        this.updateById((Object)entity);
        this.operaStatusLogService.insertLog(dto.getId(), dto.getOperaStatus());
        if (dto.getOperaStatus() == 400) {
            QgOperaBeforeVO vo = ((QgOperaDao)this.baseDao).getWxSendOperaInfo(dto.getId());
            this.xjService.operaPreachPush(vo, "\u672f\u540e\u68c0\u67e5", "\u672f\u540e\u590d\u67e5\u6d41\u7a0b", Integer.valueOf(50));
            this.xjService.operaPreachPush(vo, "\u672f\u540e\u5ba3\u6559", "\u672f\u540e\u7528\u836f\u53ca\u6ce8\u610f\u4e8b\u9879", Integer.valueOf(20));
        }
    }

    public List<QgReservationPatientVO> getPatientList(Map<String, Object> params) {
        return ((QgOperaDao)this.baseDao).getPatientList(params);
    }

    public List<QgOperaVO> getOperaList(String patientId) {
        return ((QgOperaDao)this.baseDao).getOperaList(patientId);
    }

    public void updateOperaSort(UpdateOperaSortParam dto) {
        ((QgOperaDao)this.baseDao).updateOperaSort(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveNoYuYueOpera(SaveNoYuYueOperaDTO dto) {
        QgOperaEntity entity = (QgOperaEntity)ConvertUtils.sourceToTarget((Object)dto, QgOperaEntity.class);
        entity.setOperaStatus(Integer.valueOf(0));
        this.insert((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchYuYueOpera(BatchYuYueOperaDTO dto) {
        if (CollUtil.isEmpty((Collection)dto.getOperaIds())) {
            return;
        }
        Integer isMorOrAft = null;
        if (StringUtils.isNotBlank((CharSequence)dto.getOperaDate()) && StringUtils.isNotBlank((CharSequence)dto.getOperaTime())) {
            isMorOrAft = DateUtils.judgeMorningOrAfternoon((Date)DateUtils.stringToDate((String)(dto.getOperaDate() + " " + dto.getOperaTime()), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        for (String operaId : dto.getOperaIds()) {
            QgOperaEntity entity = (QgOperaEntity)ConvertUtils.sourceToTarget((Object)dto, QgOperaEntity.class);
            entity.setId(operaId);
            entity.setOperaStatus(Integer.valueOf(100));
            entity.setCheckNumberSource(Integer.valueOf(0));
            entity.setIsMorOrAft(isMorOrAft);
            String maxOperaNumber = ((QgOperaDao)this.baseDao).selectMaxOperaNumber(DateUtils.format((Date)new Date()).replaceAll("-", ""));
            if (StringUtils.isNotBlank((CharSequence)maxOperaNumber)) {
                Long number = Long.valueOf(maxOperaNumber) + 1L;
                entity.setOperaNumber(String.valueOf(number));
            } else {
                entity.setOperaNumber(dto.getOperaDate().replaceAll("-", "") + "001");
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getOperaDate())) {
                entity.setWeekday(DateUtils.getWeekByDay((Date)DateUtils.stringToDate((String)entity.getOperaDate(), (String)"yyyy-MM-dd")));
            }
            this.updateById((Object)entity);
        }
        if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            for (String operaId : dto.getOperaIds()) {
                QgOperaDTO dbEntity = ((QgOperaDao)this.baseDao).getInfoById(operaId);
                String smsContent = ((QgOperaDao)this.baseDao).getYuyueSuccessSms(operaId);
                if (!StringUtils.isNotBlank((CharSequence)smsContent)) continue;
                String messageId = "0pfrYOXAcUy0DoN9mCoQ3gzyoUq3qWHzxxaP3im_pz8";
                HashMap<String, WxParam> paramMap = new HashMap<String, WxParam>();
                paramMap.put("first", new WxParam("\u9884\u7ea6\u6210\u529f\u63d0\u9192"));
                paramMap.put("keyword1", new WxParam(dbEntity.getOrgName()));
                paramMap.put("keyword2", new WxParam(smsContent));
                paramMap.put("keyword3", new WxParam(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")));
                paramMap.put("remark", new WxParam("\u795d\u60a8\u65e9\u65e5\u5eb7\u590d"));
                this.wxService.sendMessage(messageId, paramMap, dbEntity.getPatientIdNumber(), null, Integer.valueOf(30), "\u624b\u672f\u9884\u7ea6\u6210\u529f", "\u624b\u672f\u9884\u7ea6\u6210\u529f");
            }
        }
    }

    public void updateFinalOpera(FinalOperaParam dto) {
        dto.setFinalUserCode(SecurityUser.getEmployeeId());
        dto.setFinalTime(new Date());
        dto.setFinalUserName(SecurityUser.getUser().getRealName());
        ((QgOperaDao)this.baseDao).updateFinalOpera(dto);
    }
}

