/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.dict.param.UpdateDeviceItemParam;
import io.huimu.modules.dict.service.DictDeviceExamItemService;
import io.huimu.modules.dict.vo.DictDeviceItemVO;
import io.huimu.modules.littlecheck.dao.SysExamDeviceConfDao;
import io.huimu.modules.littlecheck.dto.SysExamDeviceConfDTO;
import io.huimu.modules.littlecheck.entity.SysExamDeviceConfEntity;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import io.huimu.modules.register.entity.ScProjectEntity;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysExamDeviceConfServiceImpl
extends BaseServiceImpl<SysExamDeviceConfDao, SysExamDeviceConfEntity>
implements SysExamDeviceConfService {
    @Autowired
    private DictDeviceExamItemService examItemService;

    public PageData<SysExamDeviceConfDTO> page(Map<String, Object> params) {
        String page = (String)params.get("page");
        String limit = (String)params.get("limit");
        PageHelper.startPage((int)Integer.parseInt(page), (int)Integer.parseInt(limit));
        List list = ((SysExamDeviceConfDao)this.baseDao).getList(params);
        for (SysExamDeviceConfDTO dto : list) {
            DictDeviceItemVO info = this.examItemService.getInfo(dto.getIdKey());
            if (info == null) continue;
            dto.setProjectEntityList(info.getProjectEntityList());
            dto.setExamineCodeList(info.getProjectEntityList().stream().map(ScProjectEntity::getExamineCode).collect(Collectors.toList()));
        }
        PageInfo pageInfo = new PageInfo(list);
        return this.getPageData(pageInfo.getList(), pageInfo.getTotal(), SysExamDeviceConfDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(SysExamDeviceConfDTO dto) {
        Integer count = ((SysExamDeviceConfDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
        if (count > 0) {
            throw new RenException("\u6b64\u8bbe\u5907ID\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        SysExamDeviceConfEntity entity = (SysExamDeviceConfEntity)ConvertUtils.sourceToTarget((Object)dto, SysExamDeviceConfEntity.class);
        entity.setCreateUserId(SecurityUser.getUser().getEmployeeId());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        entity.setDevice(entity.getIdKey());
        entity.setDeviceCode(entity.getIdKey());
        entity.setCreateDate(new Date());
        if (null != dto.getDeviceAttribute() && dto.getDeviceAttribute() == 2) {
            if (null != dto.getEffectiveDays()) {
                entity.setEffectiveDeadline(DateUtils.addDateDays((Date)new Date(), (int)dto.getEffectiveDays()));
            } else {
                entity.setEffectiveDeadline(DateUtils.addDateDays((Date)new Date(), (int)5));
            }
        }
        this.insert((Object)entity);
        UpdateDeviceItemParam param = new UpdateDeviceItemParam();
        param.setDeviceId(entity.getIdKey());
        param.setExamineCodeList(dto.getExamineCodeList());
        this.examItemService.saveOrUpdate(param);
    }

    public void update(SysExamDeviceConfDTO dto) {
        SysExamDeviceConfEntity entity = (SysExamDeviceConfEntity)ConvertUtils.sourceToTarget((Object)dto, SysExamDeviceConfEntity.class);
        entity.setCreateUserId(SecurityUser.getUser().getEmployeeId());
        entity.setCreateUserName(SecurityUser.getUser().getRealName());
        entity.setDevice(entity.getIdKey());
        entity.setDeviceCode(entity.getIdKey());
        entity.setCreateDate(new Date());
        if (null != dto.getDeviceAttribute() && dto.getDeviceAttribute() == 2) {
            if (null != dto.getEffectiveDays()) {
                entity.setEffectiveDeadline(DateUtils.addDateDays((Date)new Date(), (int)dto.getEffectiveDays()));
            } else {
                entity.setEffectiveDeadline(DateUtils.addDateDays((Date)new Date(), (int)5));
            }
        }
        this.update((Object)entity, (Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)dto.getIdKey()));
        UpdateDeviceItemParam param = new UpdateDeviceItemParam();
        param.setDeviceId(entity.getIdKey());
        param.setExamineCodeList(dto.getExamineCodeList());
        this.examItemService.saveOrUpdate(param);
    }

    public void delete(String idKey) {
        this.examItemService.delete(idKey);
        ((SysExamDeviceConfDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"ID_KEY", (Object)idKey));
    }

    public SysExamDeviceConfDTO getConfInfo(String idKey) {
        SysExamDeviceConfEntity entity = ((SysExamDeviceConfDao)this.baseDao).getConfInfo(idKey);
        SysExamDeviceConfDTO dto = (SysExamDeviceConfDTO)ConvertUtils.sourceToTarget((Object)entity, SysExamDeviceConfDTO.class);
        DictDeviceItemVO info = this.examItemService.getInfo(idKey);
        if (info != null) {
            dto.setProjectEntityList(info.getProjectEntityList());
            dto.setExamineCodeList(info.getProjectEntityList().stream().map(ScProjectEntity::getExamineCode).collect(Collectors.toList()));
        }
        return dto;
    }

    public List<SysExamDeviceConfDTO> getList(String orgCode, Integer examTypeFlag, String checkType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgCode", orgCode);
        param.put("examTypeFlag", examTypeFlag);
        param.put("checkType", checkType);
        List list = ((SysExamDeviceConfDao)this.baseDao).getList(param);
        for (SysExamDeviceConfDTO dto : list) {
            DictDeviceItemVO info = this.examItemService.getInfo(dto.getIdKey());
            if (info == null) continue;
            dto.setProjectEntityList(info.getProjectEntityList());
            dto.setExamineCodeList(info.getProjectEntityList().stream().map(ScProjectEntity::getExamineCode).collect(Collectors.toList()));
        }
        return list;
    }

    public List<SysExamDeviceConfEntity> getDeviceIdListByModel(String model) {
        return ((SysExamDeviceConfDao)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"model", (Object)model));
    }

    public Integer selectCount() {
        return ((SysExamDeviceConfDao)this.baseDao).selectCount((Wrapper)new QueryWrapper().eq((Object)"device_attribute", (Object)1));
    }

    public void changeAttribute(String deviceId) {
        ((SysExamDeviceConfDao)this.baseDao).changeAttribute(deviceId);
    }
}

