/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.littlecheck.dao.DeviceParamDao;
import io.huimu.modules.littlecheck.dto.DeviceParamChildrenDTO;
import io.huimu.modules.littlecheck.dto.DeviceParamDTO;
import io.huimu.modules.littlecheck.entity.DeviceParamEntity;
import io.huimu.modules.littlecheck.service.DeviceParamService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceParamServiceImpl
extends BaseServiceImpl<DeviceParamDao, DeviceParamEntity>
implements DeviceParamService {
    public void save(DeviceParamDTO dto) {
        Integer count = ((DeviceParamDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARAM_TYPE", (Object)dto.getParamType())).eq((Object)"PID", (Object)dto.getPid())).eq((Object)"CONTENT", (Object)dto.getContent())).eq((Object)"CONTENT1", (Object)dto.getContent1()));
        if (count > 0) {
            throw new RenException("\u5185\u5bb9\u5df2\u5b58\u5728");
        }
        DeviceParamEntity entity = (DeviceParamEntity)ConvertUtils.sourceToTarget((Object)dto, DeviceParamEntity.class);
        entity.setPids(this.getPidList(entity.getPid()));
        entity.setCreateDate(new Date());
        this.insert((Object)entity);
    }

    public void update(DeviceParamDTO dto) {
        Integer count = ((DeviceParamDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARAM_TYPE", (Object)dto.getParamType())).eq((Object)"PID", (Object)dto.getPid())).eq((Object)"CONTENT", (Object)dto.getContent())).eq((Object)"CONTENT1", (Object)dto.getContent1())).ne((Object)"ID", (Object)dto.getId()));
        if (count > 0) {
            throw new RenException("\u5185\u5bb9\u5df2\u5b58\u5728");
        }
        DeviceParamEntity entity = (DeviceParamEntity)ConvertUtils.sourceToTarget((Object)dto, DeviceParamEntity.class);
        entity.setPids(this.getPidList(entity.getPid()));
        entity.setCreateDate(new Date());
        this.updateById((Object)entity);
    }

    public DeviceParamDTO getInfo(String id) {
        DeviceParamEntity entity = (DeviceParamEntity)((DeviceParamDao)this.baseDao).selectById((Serializable)((Object)id));
        return (DeviceParamDTO)ConvertUtils.sourceToTarget((Object)entity, DeviceParamDTO.class);
    }

    private String getPidList(String pid) {
        if ("0".equals(pid)) {
            return "0";
        }
        List deptList = ((DeviceParamDao)this.baseDao).selectList((Wrapper)new QueryWrapper());
        HashMap<String, DeviceParamEntity> map = new HashMap<String, DeviceParamEntity>(deptList.size());
        for (DeviceParamEntity entity : deptList) {
            map.put(entity.getId(), entity);
        }
        ArrayList pidList = new ArrayList();
        this.getPidTree(pid, map, pidList);
        return StringUtils.join(pidList, (String)",");
    }

    private void getPidTree(String pid, Map<String, DeviceParamEntity> map, List<String> pidList) {
        if ("0".equals(pid)) {
            return;
        }
        DeviceParamEntity parent = map.get(pid);
        if (parent != null) {
            this.getPidTree(parent.getPid(), map, pidList);
        }
        pidList.add(pid);
    }

    public List<DeviceParamDTO> getListByPid(String pid, Integer isOpen, String category) {
        List list = ((DeviceParamDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(null != isOpen, (Object)"IS_OPEN", (Object)isOpen)).eq(StringUtils.isNotBlank((CharSequence)category), (Object)"CATEGORY", (Object)category)).eq((Object)"PID", (Object)pid)).orderByAsc((Object)"SORT_INDEX"));
        return ConvertUtils.sourceToTarget((Collection)list, DeviceParamDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String[] ids) {
        for (String id : ids) {
            ((DeviceParamDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id));
            ((DeviceParamDao)this.baseDao).delete((Wrapper)new QueryWrapper().like((Object)"PIDS", (Object)("%" + id + "%")));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOpen(String id, Integer isOpen) {
        DeviceParamEntity entity = new DeviceParamEntity();
        entity.setId(id);
        entity.setIsOpen(isOpen);
        this.updateById((Object)entity);
    }

    public List<DeviceParamChildrenDTO> getChildrenList(Integer isOpen, String category) {
        List list = ((DeviceParamDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq(null != isOpen, (Object)"IS_OPEN", (Object)isOpen)).eq(StringUtils.isNotBlank((CharSequence)category), (Object)"CATEGORY", (Object)category)).orderByAsc((Object)"SORT_INDEX"));
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, DeviceParamChildrenDTO.class), (String)"0");
    }
}

