/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.littlecheck.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.common.utils.FileUtils;
import io.huimu.modules.littlecheck.dao.DeviceFileDao;
import io.huimu.modules.littlecheck.dto.DeviceFileDTO;
import io.huimu.modules.littlecheck.dto.SysExamDeviceConfDTO;
import io.huimu.modules.littlecheck.entity.DeviceFileEntity;
import io.huimu.modules.littlecheck.service.DeviceFileService;
import io.huimu.modules.littlecheck.service.SysExamDeviceConfService;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.upload.entity.UploadEntity;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceFileServiceImpl
extends BaseServiceImpl<DeviceFileDao, DeviceFileEntity>
implements DeviceFileService {
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private SysExamDeviceConfService deviceConfService;

    public PageData<DeviceFileEntity> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"brand", "model", "patientId", "deviceOutType"});
        IPage page = this.getPage(params, "", false);
        List list = ((DeviceFileDao)this.baseDao).getList(params);
        List resList = ConvertUtils.sourceToTarget((Collection)list, DeviceFileEntity.class);
        return this.getPageData(resList, page.getTotal(), DeviceFileEntity.class);
    }

    public void save(DeviceFileDTO dto) throws IOException {
        SysExamDeviceConfDTO deviceConfDTO = this.deviceConfService.getConfInfo(dto.getDeviceId());
        if (null == deviceConfDTO) {
            throw new RenException("\u8bbe\u5907\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String fileName = deviceConfDTO.getBrand() + "-" + deviceConfDTO.getModel() + "-" + deviceConfDTO.getDeviceOutType() + "-" + DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".txt";
        DeviceFileEntity entity = (DeviceFileEntity)ConvertUtils.sourceToTarget((Object)dto, DeviceFileEntity.class);
        entity.setBrand(deviceConfDTO.getBrand());
        entity.setModel(deviceConfDTO.getModel());
        entity.setDeviceOutType(deviceConfDTO.getDeviceOutType());
        String ftpPath = this.sysSystemConfService.getConfValue("100007", null);
        UploadEntity uploadEntity = FileUtils.writeToFile((String)dto.getDeviceData(), (String)ftpPath, (String)("device_data/" + deviceConfDTO.getBrand() + "/" + deviceConfDTO.getModel() + "/" + dto.getPatientId()), (String)fileName, (String)"txt");
        entity.setFilePath(uploadEntity.getFilePath());
        this.insert((Object)entity);
    }

    public List<DeviceFileEntity> selectDelList() {
        return ((DeviceFileDao)this.baseDao).selectDelList(DateUtils.format((Date)new Date()));
    }
}

