/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.license.controller;

import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.license.dto.LicenseDTO;
import io.huimu.modules.license.service.LicenseService;
import io.huimu.modules.license.vo.LicenseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/license"})
@Api(tags={"\u7cfb\u7edf\u6388\u6743\u7801\u7ba1\u7406"})
public class LicenseController {
    @Autowired
    private LicenseService licenseService;

    @PostMapping(value={"checkDeviceLicense"})
    @ApiOperation(value="\u6821\u9a8c\u8bbe\u5907\u6388\u6743\u7801")
    public Result checkDeviceLicense(@RequestBody EncryptedReq<NoParam> req) throws IOException {
        LicenseVO vo = this.licenseService.checkDeviceLicense();
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"saveDeviceLicense"})
    @ApiOperation(value="\u4fdd\u5b58\u8bbe\u5907\u6388\u6743\u7801")
    public Result saveDeviceLicense(@RequestBody EncryptedReq<LicenseDTO> req) {
        LicenseDTO dto = (LicenseDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        LicenseVO vo = this.licenseService.saveDeviceLicense(dto);
        return new Result().ok(req.getEncode(), (Object)vo);
    }
}

