/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.jsversion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.modules.jsversion.dao.OboxDao;
import io.huimu.modules.jsversion.dto.OboxDTO;
import io.huimu.modules.jsversion.entity.OboxEntity;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.huimu.modules.jsversion.service.OboxService;
import io.huimu.modules.jsversion.vo.OboxVO;
import io.huimu.modules.sys.service.SysSystemConfService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OboxServiceImpl
extends BaseServiceImpl<OboxDao, OboxEntity>
implements OboxService {
    @Autowired
    private SysSystemConfService sysSystemConfService;

    public PageData<OboxDTO> page(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"fileName", "jsVersion"});
        String jsVersion = (String)params.get("jsVersion");
        String fileName = (String)params.get("fileName");
        IPage page = ((OboxDao)this.baseDao).selectPage(this.getPage(params, "create_date", true), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((CharSequence)jsVersion), (Object)"JS_VERSION", (Object)jsVersion)).like(StringUtils.isNotBlank((CharSequence)fileName), (Object)"FILE_NAME", (Object)fileName)).orderByDesc((Object)"JS_VERSION"));
        return this.getPageData(page, OboxDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void pushVersion(OboxDTO dto) {
        OboxEntity entity = new OboxEntity();
        if (dto.getIsOpen() == 1) {
            entity = new OboxEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new OboxEntity();
        entity.setFileName(dto.getFileName());
        entity.setFilePath(dto.getFilePath());
        entity.setCreateDate(new Date());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setJsVersion(dto.getJsVersion());
        this.insert((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateVersion(OboxDTO dto) {
        OboxEntity entity = new OboxEntity();
        if (dto.getIsOpen() == 1) {
            entity = new OboxEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new OboxEntity();
        entity.setId(dto.getId());
        entity.setIsOpen(dto.getIsOpen());
        entity.setMessage(dto.getMessage());
        entity.setJsVersion(dto.getJsVersion());
        this.updateById((Object)entity);
    }

    public OboxDTO getInfo(String id) {
        OboxEntity entity = (OboxEntity)((OboxDao)this.baseDao).selectById((Serializable)((Object)id));
        return (OboxDTO)ConvertUtils.sourceToTarget((Object)entity, OboxDTO.class);
    }

    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(ChangeOpenParam data) {
        OboxEntity entity = new OboxEntity();
        if (data.getIsOpen() == 1) {
            entity = new OboxEntity();
            entity.setIsOpen(Integer.valueOf(0));
            this.update((Object)entity, (Wrapper)new QueryWrapper());
        }
        entity = new OboxEntity();
        entity.setIsOpen(data.getIsOpen());
        entity.setId(data.getId());
        this.updateById((Object)entity);
    }

    public OboxVO getOpenObox() {
        return ((OboxDao)this.baseDao).getOpenObox();
    }
}

