/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.utils;

import io.huimu.common.exception.ExceptionUtils;
import io.huimu.common.utils.SpringContextUtils;
import io.huimu.modules.job.entity.ScheduleJobEntity;
import io.huimu.modules.job.entity.ScheduleJobLogEntity;
import io.huimu.modules.job.service.ScheduleJobLogService;
import java.lang.reflect.Method;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ScheduleJob
extends QuartzJobBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) {
        ScheduleJobEntity scheduleJob = (ScheduleJobEntity)context.getMergedJobDataMap().get((Object)"JOB_PARAM_KEY");
        ScheduleJobLogEntity log = new ScheduleJobLogEntity();
        log.setJobId(scheduleJob.getId());
        log.setBeanName(scheduleJob.getBeanName());
        log.setParams(scheduleJob.getParams());
        log.setCreateDate(new Date());
        long startTime = System.currentTimeMillis();
        try {
            this.logger.info("\u4efb\u52a1\u51c6\u5907\u6267\u884c\uff0c\u4efb\u52a1ID\uff1a{}", (Object)scheduleJob.getId());
            Object target = SpringContextUtils.getBean((String)scheduleJob.getBeanName());
            Method method = target.getClass().getDeclaredMethod("run", String.class);
            method.invoke(target, scheduleJob.getParams());
            long times = System.currentTimeMillis() - startTime;
            log.setTimes(Integer.valueOf((int)times));
            log.setStatus(Integer.valueOf(1));
            this.logger.info("\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1ID\uff1a{}  \u603b\u5171\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)scheduleJob.getId(), (Object)times);
        }
        catch (Exception e) {
            this.logger.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1ID\uff1a{}", (Object)scheduleJob.getId(), (Object)e);
            long times = System.currentTimeMillis() - startTime;
            log.setTimes(Integer.valueOf((int)times));
            log.setStatus(Integer.valueOf(0));
            log.setError(ExceptionUtils.getErrorStackTrace((Exception)e));
        }
        finally {
            ScheduleJobLogService scheduleJobLogService = (ScheduleJobLogService)SpringContextUtils.getBean(ScheduleJobLogService.class);
            scheduleJobLogService.insert((Object)log);
        }
    }
}

