/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.job.task;

import io.huimu.modules.job.task.ITask;
import io.huimu.modules.sys.service.SysSystemConfService;
import io.huimu.modules.visit.service.VisitPatientService;
import io.huimu.modules.visit.vo.VisitSendSmsVO;
import io.huimu.modules.wx.service.WxService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="visitSendMessageTask")
public class VisitSendMessageTask
implements ITask {
    @Autowired
    private VisitPatientService visitPatientService;
    @Autowired
    private SysSystemConfService sysSystemConfService;
    @Autowired
    private WxService wxService;
    @Value(value="${hospitalCode}")
    private String hospitalCode;

    public void run(String params) {
        if (this.hospitalCode.equalsIgnoreCase("NJYK")) {
            String wxTemplateId = this.sysSystemConfService.getConfValue("100044", null);
            if (StringUtils.isBlank((CharSequence)wxTemplateId)) {
                return;
            }
            List resList = this.visitPatientService.getVisitSendList(null);
            for (VisitSendSmsVO vo : resList) {
                Map param = this.wxService.getSendWxMsgParam(vo.getOrgName(), vo.getPatientName(), vo.getSmsMessage());
                this.wxService.sendMessage(wxTemplateId, param, vo.getPatientIdNumber(), null, Integer.valueOf(20), null, null);
                this.visitPatientService.updateSendInfo(vo.getId(), Integer.valueOf(1));
            }
        }
    }
}

