/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.hisregister.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.DateUtils;
import io.huimu.modules.hisregister.dao.HisRegisterDao;
import io.huimu.modules.hisregister.dto.HisRegisterDTO;
import io.huimu.modules.hisregister.dto.SaveHisRegisterDTO;
import io.huimu.modules.hisregister.entity.HisRegisterEntity;
import io.huimu.modules.hisregister.entity.HisRegisterRecordEntity;
import io.huimu.modules.hisregister.param.DeletePatientParam;
import io.huimu.modules.hisregister.param.JzParam;
import io.huimu.modules.hisregister.param.RemovePatientParam;
import io.huimu.modules.hisregister.service.HisRegisterRecordService;
import io.huimu.modules.hisregister.service.HisRegisterService;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HisRegisterServiceImpl
extends BaseServiceImpl<HisRegisterDao, HisRegisterEntity>
implements HisRegisterService {
    @Autowired
    private HisRegisterRecordService hisRegisterRecordService;

    public PageData<HisRegisterDTO> mzPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber", "doctorName"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((HisRegisterDao)this.baseDao).getMzList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public PageData<HisRegisterDTO> qgMzPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber", "doctorName"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((HisRegisterDao)this.baseDao).getQgMzList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public PageData<HisRegisterDTO> qgYjPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber", "doctorName"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((HisRegisterDao)this.baseDao).getQgYjList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public HisRegisterDTO getPatientInfo(Map<String, Object> params) {
        return ((HisRegisterDao)this.baseDao).getPatientInfo(params);
    }

    public void deletePatient(DeletePatientParam data) {
        ((HisRegisterDao)this.baseDao).delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)data.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)data.getOrgCode()));
    }

    public PageData<HisRegisterDTO> qgCzPage(Map<String, Object> params) {
        this.paramsToLike(params, new String[]{"patientId", "patientName", "mzNumber", "doctorName"});
        PageHelper.startPage((int)Integer.parseInt(params.get("page").toString()), (int)Integer.parseInt(params.get("limit").toString()));
        List list = ((HisRegisterDao)this.baseDao).getQgCzList(params);
        PageInfo pageInfo = new PageInfo(list);
        return new PageData(pageInfo.getList(), pageInfo.getTotal());
    }

    public void jz(JzParam data) {
        HisRegisterEntity entity = new HisRegisterEntity();
        entity.setIsJz(Integer.valueOf(1));
        entity.setJzDoctorCode(SecurityUser.getEmployeeId());
        entity.setJzTime(new Date());
        entity.setJzDoctorName(SecurityUser.getUser().getRealName());
        this.update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)data.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)data.getOrgCode()));
    }

    public HisRegisterEntity getTodayPatient(String patientId, String hospitalOrgCode) {
        return (HisRegisterEntity)((HisRegisterDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)patientId)).eq((Object)"hospital_code", (Object)hospitalOrgCode)).eq((Object)"to_char(his_time,'yyyy-MM-dd')", (Object)DateUtils.format((Date)new Date())));
    }

    public String selectJzNumber() {
        return ((HisRegisterDao)this.baseDao).selectJzNumber();
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveHisRecord(HisRegisterEntity hisRegisterEntity) {
        hisRegisterEntity.setHisTime(new Date());
        Integer count = ((HisRegisterDao)this.baseDao).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)hisRegisterEntity.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)hisRegisterEntity.getHospitalCode()));
        if (count > 0) {
            this.update((Object)hisRegisterEntity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)hisRegisterEntity.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)hisRegisterEntity.getHospitalCode()));
        } else {
            this.insert((Object)hisRegisterEntity);
        }
        this.hisRegisterRecordService.saveOrUpdate((HisRegisterRecordEntity)ConvertUtils.sourceToTarget((Object)hisRegisterEntity, HisRegisterRecordEntity.class));
    }

    public void updatePatient(HisRegisterDTO data) {
        ((HisRegisterDao)this.baseDao).update(ConvertUtils.sourceToTarget((Object)data, HisRegisterEntity.class), (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)data.getPatientId())).eq((Object)"hospital_code", (Object)data.getHospitalCode()));
    }

    public HisRegisterEntity selectPatientId(String orgCode, String patientIdNumber) {
        List list = ((HisRegisterDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"hospital_code", (Object)orgCode)).eq((Object)"patient_id_number", (Object)patientIdNumber)).orderByDesc((Object)"HIS_TIME"));
        if (CollUtil.isNotEmpty((Collection)list)) {
            return (HisRegisterEntity)list.get(0);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePatient(SaveHisRegisterDTO data) {
        HisRegisterEntity hisRegisterEntity = (HisRegisterEntity)ConvertUtils.sourceToTarget((Object)data, HisRegisterEntity.class);
        hisRegisterEntity.setHisTime(new Date());
        hisRegisterEntity.setGhDoctorName(SecurityUser.getUser().getRealName());
        hisRegisterEntity.setGhDoctorCode(SecurityUser.getEmployeeId());
        hisRegisterEntity.setIsRemove(Integer.valueOf(0));
        hisRegisterEntity.setIsQg(Integer.valueOf(1));
        HisRegisterEntity dbEntity = (HisRegisterEntity)((HisRegisterDao)this.baseDao).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)hisRegisterEntity.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)hisRegisterEntity.getHospitalCode()));
        if (null != dbEntity) {
            this.update((Object)hisRegisterEntity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PATIENT_ID", (Object)hisRegisterEntity.getPatientId())).eq((Object)"HOSPITAL_CODE", (Object)hisRegisterEntity.getHospitalCode()));
        } else {
            this.insert((Object)hisRegisterEntity);
        }
        this.hisRegisterRecordService.saveOrUpdate((HisRegisterRecordEntity)ConvertUtils.sourceToTarget((Object)hisRegisterEntity, HisRegisterRecordEntity.class));
    }

    public List<String> getWxPatientId(String patientIdNumber) {
        return ((HisRegisterDao)this.baseDao).getWxPatientId(patientIdNumber);
    }

    public void removePatient(RemovePatientParam data) {
        HisRegisterEntity entity = new HisRegisterEntity();
        entity.setIsRemove(Integer.valueOf(1));
        this.update((Object)entity, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"patient_id", (Object)data.getPatientId())).eq((Object)"hospital_code", (Object)data.getOrgCode()));
    }
}

