/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.dict.dao.DictMenuFieldDeviceDao;
import io.huimu.modules.dict.dto.DynamicTitleDTO;
import io.huimu.modules.dict.dto.SetDynamicTitleDTO;
import io.huimu.modules.dict.entity.DictMenuFieldDeviceEntity;
import io.huimu.modules.dict.param.DictMenuFieldSearchParam;
import io.huimu.modules.dict.service.DictMenuFieldDeviceService;
import io.huimu.modules.dict.vo.DictMenuFieldVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictMenuFieldDeviceServiceImpl
extends BaseServiceImpl<DictMenuFieldDeviceDao, DictMenuFieldDeviceEntity>
implements DictMenuFieldDeviceService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(SetDynamicTitleDTO titleDTO) {
        ((DictMenuFieldDeviceDao)this.baseDao).delete((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().isNull(StringUtils.isBlank((CharSequence)titleDTO.getDeviceId()), (Object)"DEVICE_ID")).eq(StringUtils.isNotBlank((CharSequence)titleDTO.getDeviceId()), (Object)"DEVICE_ID", (Object)titleDTO.getDeviceId())).eq((Object)"MENU_URL", (Object)titleDTO.getMenuUrl()));
        if (CollUtil.isNotEmpty((Collection)titleDTO.getTitleList())) {
            ArrayList<DictMenuFieldDeviceEntity> insertList = new ArrayList<DictMenuFieldDeviceEntity>();
            for (DynamicTitleDTO dto : titleDTO.getTitleList()) {
                DictMenuFieldDeviceEntity entity = new DictMenuFieldDeviceEntity();
                entity.setFieldId(dto.getId());
                entity.setSortIndex(dto.getSortIndex());
                entity.setDeviceId(titleDTO.getDeviceId());
                entity.setMenuUrl(titleDTO.getMenuUrl());
                insertList.add(entity);
            }
            this.insertBatch(insertList, 20);
        }
    }

    public List<DictMenuFieldVO> getDynamicTitleList(DictMenuFieldSearchParam dto) {
        return ((DictMenuFieldDeviceDao)this.baseDao).getDynamicTitleList(dto.getDeviceId(), dto.getMenuUrl());
    }

    public List<DictMenuFieldVO> getDeviceDynamicTitleList(DictMenuFieldSearchParam dto) {
        List list = ((DictMenuFieldDeviceDao)this.baseDao).getDeviceDynamicTitleList(dto.getDeviceId(), dto.getMenuUrl());
        if (CollUtil.isEmpty((Collection)list)) {
            List allList = ((DictMenuFieldDeviceDao)this.baseDao).getDynamicTitleList(dto.getDeviceId(), dto.getMenuUrl());
            return allList;
        }
        return list;
    }
}

