/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.modules.dict.dao.DictDataExtractShowDao;
import io.huimu.modules.dict.entity.DictDataExtractShowConfEntity;
import io.huimu.modules.dict.service.DictDataExtractShowService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictDataExtractShowServiceImpl
extends BaseServiceImpl<DictDataExtractShowDao, DictDataExtractShowConfEntity>
implements DictDataExtractShowService {
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(String deviceId, List<String> dataExtractShowConfIds) {
        ((DictDataExtractShowDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"device_id", (Object)deviceId));
        if (CollUtil.isEmpty(dataExtractShowConfIds)) {
            return;
        }
        ArrayList<DictDataExtractShowConfEntity> list = new ArrayList<DictDataExtractShowConfEntity>();
        for (String confId : dataExtractShowConfIds) {
            DictDataExtractShowConfEntity entity = new DictDataExtractShowConfEntity();
            entity.setDeviceId(deviceId);
            entity.setDataExtractConfId(confId);
            list.add(entity);
        }
        if (CollUtil.isNotEmpty(list)) {
            this.insertBatch(list);
        }
    }

    public void deleteByConfIds(List<String> confIds) {
        ((DictDataExtractShowDao)this.baseDao).delete((Wrapper)new QueryWrapper().in((Object)"data_extract_conf_id", confIds));
    }

    public List<String> getDataExtractShowConfIds(String deviceId) {
        return ((DictDataExtractShowDao)this.baseDao).getDataExtractShowConfIds(deviceId);
    }
}

