/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictStandardNameDTO;
import io.huimu.modules.dict.param.DictStandardNamePageParam;
import io.huimu.modules.dict.service.DictStandardNameService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/standard"})
@Api(tags={"\u6807\u51c6\u540d\u79f0\u7ba1\u7406"})
public class DictStandardNameController {
    @Autowired
    private DictStandardNameService dictStandardNameService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=DictStandardNamePageParam.class)
    public Result<PageData<DictStandardNameDTO>> page(@RequestBody EncryptedReq<DictStandardNamePageParam> req) throws IllegalAccessException {
        DictStandardNamePageParam dto = (DictStandardNamePageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.dictStandardNameService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u65b0\u589e", module="\u6807\u51c6\u540d\u79f0\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=DictStandardNameDTO.class)
    public Result save(@RequestBody EncryptedReq<DictStandardNameDTO> req) {
        DictStandardNameDTO dto = (DictStandardNameDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictStandardNameService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539", module="\u6807\u51c6\u540d\u79f0\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=DictStandardNameDTO.class)
    public Result update(@RequestBody EncryptedReq<DictStandardNameDTO> req) {
        DictStandardNameDTO dto = (DictStandardNameDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictStandardNameService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictStandardNameDTO vo = this.dictStandardNameService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.dictStandardNameService.getList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getExamModalityList"})
    @ApiOperation(value="\u83b7\u53d6\u68c0\u67e5\u6a21\u6001\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getExamModalityList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.dictStandardNameService.getExamModalityList();
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"batchDel"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    @LogOperation(value="\u6279\u91cf\u5220\u9664", module="\u6807\u51c6\u540d\u79f0\u7ba1\u7406", operationType=3)
    public Result batchDel(@RequestBody EncryptedReq<ArraysParam> req) {
        ArraysParam dto = (ArraysParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictStandardNameService.batchDel(dto.getIds());
        return new Result();
    }
}

