/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.modules.dict.dto.DictStandardDataSetDTO;
import io.huimu.modules.dict.excel.DictStandardDataSetExcel;
import io.huimu.modules.dict.param.GetDatasetTypeParam;
import io.huimu.modules.dict.param.GetStandardDataSetParam;
import io.huimu.modules.dict.service.DictStandardDataSetService;
import io.huimu.modules.dict.vo.DatasetTypeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/standard/data/set"})
@Api(tags={"\u56fd\u5bb6\u7535\u5b50\u75c5\u5386\u6807\u51c6\u6570\u636e\u96c6\u7ba1\u7406"})
public class DictStandardDataSetController {
    @Autowired
    private DictStandardDataSetService standardDataSetService;

    @PostMapping(value={"getDatasetTypePage"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u96c6\u540d\u79f0\u5217\u8868")
    @DecryptAndVerify(decryptedClass=GetDatasetTypeParam.class)
    public Result<PageData<DatasetTypeVO>> getDatasetTypePage(@RequestBody EncryptedReq<GetDatasetTypeParam> req) throws IllegalAccessException {
        GetDatasetTypeParam param = (GetDatasetTypeParam)req.getData();
        ValidatorUtils.validateEntity((Object)param, (Class[])new Class[0]);
        PageData pageData = this.standardDataSetService.getDatasetTypePage(MapUtils.object2Map((Object)param));
        return new Result().ok(req.getEncode(), (Object)pageData);
    }

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetStandardDataSetParam.class)
    public Result<PageData<DictStandardDataSetDTO>> page(@RequestBody EncryptedReq<GetStandardDataSetParam> req) throws IllegalAccessException {
        GetStandardDataSetParam params = (GetStandardDataSetParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[0]);
        PageData page = this.standardDataSetService.page(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"uploadExcel"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @LogOperation(value="\u4e0a\u4f20\u6587\u4ef6", module="\u56fd\u5bb6\u7535\u5b50\u75c5\u5386\u6807\u51c6\u6570\u636e\u96c6\u7ba1\u7406", operationType=1, logType=1)
    public Result uploadExcel(@RequestPart(value="file", required=false) MultipartFile file) throws IOException {
        if (null == file) {
            return new Result().error("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList list = new ArrayList();
        EasyExcel.read((InputStream)file.getInputStream(), DictStandardDataSetExcel.class, (ReadListener)new /* Unavailable Anonymous Inner Class!! */).doReadAll();
        this.standardDataSetService.batchSaveByExcel(list);
        return new Result();
    }
}

