/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArraysParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictMenuFieldDTO;
import io.huimu.modules.dict.dto.SetDynamicTitleDTO;
import io.huimu.modules.dict.param.DictMenuFieldPageParam;
import io.huimu.modules.dict.param.DictMenuFieldSearchParam;
import io.huimu.modules.dict.service.DictMenuFieldDeviceService;
import io.huimu.modules.dict.service.DictMenuFieldService;
import io.huimu.modules.dict.vo.DictMenuFieldVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menu/field"})
@Api(tags={"\u83dc\u5355\u8868\u5934\u7ba1\u7406"})
public class DictMenuFieldController {
    @Autowired
    private DictMenuFieldService dictMenuFieldService;
    @Autowired
    private DictMenuFieldDeviceService dictMenuFieldDeviceService;

    @PostMapping(value={"getPage"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictMenuFieldPageParam.class)
    public Result<PageData<DictMenuFieldVO>> getPage(@RequestBody EncryptedReq<DictMenuFieldPageParam> req) throws IllegalAccessException {
        DictMenuFieldPageParam dto = (DictMenuFieldPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.dictMenuFieldService.getPage(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @LogOperation(value="\u65b0\u589e", module="\u83dc\u5355\u8868\u5934\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=DictMenuFieldDTO.class)
    public Result save(@RequestBody EncryptedReq<DictMenuFieldDTO> req) {
        DictMenuFieldDTO dto = (DictMenuFieldDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictMenuFieldService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @LogOperation(value="\u4fee\u6539", module="\u83dc\u5355\u8868\u5934\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=DictMenuFieldDTO.class)
    public Result update(@RequestBody EncryptedReq<DictMenuFieldDTO> req) {
        DictMenuFieldDTO dto = (DictMenuFieldDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictMenuFieldService.update(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictMenuFieldVO vo = this.dictMenuFieldService.getInfo(dto.getId());
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)vo, DictMenuFieldVO.class));
    }

    @PostMapping(value={"batchDel"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DecryptAndVerify(decryptedClass=ArraysParam.class)
    @LogOperation(value="\u6279\u91cf\u5220\u9664", module="\u83dc\u5355\u8868\u5934\u7ba1\u7406", operationType=3)
    public Result batchDel(@RequestBody EncryptedReq<ArraysParam> req) {
        ArraysParam dto = (ArraysParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictMenuFieldService.batchDel(dto.getIds());
        return new Result();
    }

    @PostMapping(value={"setDynamicTitle"})
    @ApiOperation(value="\u8bbe\u7f6e\u52a8\u6001\u8868\u5934")
    @DecryptAndVerify(decryptedClass=SetDynamicTitleDTO.class)
    @LogOperation(value="\u8bbe\u7f6e\u52a8\u6001\u8868\u5934", module="\u68c0\u67e5\u6570\u636e\u7ba1\u7406", operationType=1, logType=1)
    public Result setDynamicTitle(@RequestBody EncryptedReq<SetDynamicTitleDTO> req) {
        SetDynamicTitleDTO dto = (SetDynamicTitleDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictMenuFieldDeviceService.saveOrUpdate(dto);
        return new Result();
    }

    @PostMapping(value={"getDynamicTitleList"})
    @ApiOperation(value="\u83b7\u53d6\u52a8\u6001\u8868\u5934\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictMenuFieldSearchParam.class)
    public Result getDynamicTitleList(@RequestBody EncryptedReq<DictMenuFieldSearchParam> req) {
        DictMenuFieldSearchParam dto = (DictMenuFieldSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.dictMenuFieldDeviceService.getDynamicTitleList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"getDeviceDynamicTitleList"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u52a8\u6001\u8868\u5934\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictMenuFieldSearchParam.class)
    public Result getDeviceDynamicTitleList(@RequestBody EncryptedReq<DictMenuFieldSearchParam> req) {
        DictMenuFieldSearchParam dto = (DictMenuFieldSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.dictMenuFieldDeviceService.getDeviceDynamicTitleList(dto);
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

