/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictExamAddressDTO;
import io.huimu.modules.dict.entity.DictExamAddressEntity;
import io.huimu.modules.dict.param.DictExamAddressListParam;
import io.huimu.modules.dict.param.DictExamAddressPageParam;
import io.huimu.modules.dict.param.DictExamAddressSearchParam;
import io.huimu.modules.dict.service.DictExamAddressService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exam/address"})
@Api(tags={"\u68c0\u67e5\u5730\u70b9\u7ba1\u7406"})
public class DictExamAddressController {
    @Autowired
    private DictExamAddressService examAddressService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=DictExamAddressPageParam.class)
    public Result<PageData<DictExamAddressDTO>> page(@RequestBody EncryptedReq<DictExamAddressPageParam> req) throws IllegalAccessException {
        DictExamAddressPageParam dto = (DictExamAddressPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        PageData page = this.examAddressService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=DictExamAddressDTO.class)
    @LogOperation(value="\u4fdd\u5b58", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=1)
    public Result save(@RequestBody EncryptedReq<DictExamAddressDTO> req) {
        DictExamAddressDTO dto = (DictExamAddressDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.examAddressService.save(dto);
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=DictExamAddressDTO.class)
    @LogOperation(value="\u4fee\u6539", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=2)
    public Result update(@RequestBody EncryptedReq<DictExamAddressDTO> req) {
        DictExamAddressDTO dto = (DictExamAddressDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.examAddressService.update(dto);
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u68c0\u67e5\u5730\u70b9\u7ba1\u7406", operationType=3)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.examAddressService.delete(dto.getId());
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictExamAddressEntity en = (DictExamAddressEntity)this.examAddressService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)en, DictExamAddressDTO.class));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictExamAddressListParam.class)
    public Result getList(@RequestBody EncryptedReq<DictExamAddressListParam> req) {
        DictExamAddressListParam dto = (DictExamAddressListParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.examAddressService.getList(dto);
        return new Result().ok(req.getEncode(), (Object)ConvertUtils.sourceToTarget((Collection)list, DictExamAddressDTO.class));
    }

    @PostMapping(value={"getListByExamCode"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5code\uff0c\u83b7\u53d6\u5730\u70b9\u5217\u8868")
    @DecryptAndVerify(decryptedClass=DictExamAddressSearchParam.class)
    public Result getListByExamCode(@RequestBody EncryptedReq<DictExamAddressSearchParam> req) {
        DictExamAddressSearchParam dto = (DictExamAddressSearchParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.examAddressService.getListByExamCode(dto.getOrgCode(), dto.getExamCode());
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

